/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.Deal;
import com.ericsson.ejb.Document;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="CM_DEAL_DOCUMENTS")
public class DealDocuments
implements Serializable,
Document {
    private static final long serialVersionUID = 3651963931497288183L;
    private Long idDocument;
    private Deal deal;
    private String fileName;
    private byte[] fileBytes;

    public DealDocuments() {
    }

    public DealDocuments(Deal deal) {
        this.deal = deal;
    }

    public DealDocuments(Deal deal, String fileName, byte[] dealFile) {
        this.deal = deal;
        this.fileName = fileName;
        this.fileBytes = dealFile;
    }

    @Override
    @Id
    @Column(name="ID_DOCUMENT", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="DealDocumentID Sequence Generator", sequenceName="CM_DEAL_DOCUMENTS_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DealDocumentID Sequence Generator")
    public Long getIdDocument() {
        return this.idDocument;
    }

    public void setIdDocument(Long idDocument) {
        this.idDocument = idDocument;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DEAL", nullable=false)
    public Deal getDeal() {
        return this.deal;
    }

    public void setDeal(Deal deal) {
        this.deal = deal;
    }

    @Override
    @Column(name="FILE_NAME", length=50)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    @Column(name="DEAL_FILE")
    public byte[] getFileBytes() {
        return this.fileBytes;
    }

    public void setFileBytes(byte[] dealFile) {
        this.fileBytes = dealFile;
    }
}

