/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.LicenseDocuments;
import com.ericsson.ejb.LicenseType;
import com.ericsson.ejb.SmAssets;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CM_LICENSE")
public class License
implements Serializable {
    private static final long serialVersionUID = -2484928322902760612L;
    private Long idLicense;
    private LicenseType licenseType;
    private Deal deal;
    private String name;
    private Boolean active;
    private Date creationDate;
    private Date effectiveDate;
    private Date expiryDate;
    private String notes;
    private String contentProvider;
    private Set<LicenseDocuments> licenseDocuments = new HashSet<LicenseDocuments>(0);
    private Set<CustomLicFieldValue> licenseCustomLicFieldValues = new HashSet<CustomLicFieldValue>(0);
    private Set<LicenseDetails> licenseDetails = new HashSet<LicenseDetails>(0);
    private Boolean allAssets;
    private Set<SmAssets> smAssets = new HashSet<SmAssets>(0);
    private Date updateDate = new Date();
    private String externalId;

    public License() {
        this.allAssets = Boolean.TRUE;
    }

    public License(LicenseType licenseType, Deal deal, String name, Boolean active, Date creationDate, Date effectiveDate, Date expiryDate, String notes, String contentProvider, Boolean allAssets) {
        this.licenseType = licenseType;
        this.deal = deal;
        this.name = name;
        this.active = active;
        this.creationDate = creationDate;
        this.effectiveDate = effectiveDate;
        this.expiryDate = expiryDate;
        this.notes = notes;
        this.contentProvider = contentProvider;
        this.allAssets = allAssets;
    }

    public License(LicenseType licenseType, Deal deal, String name, Boolean active, Date creationDate, Date effectiveDate, Date expiryDate, String notes, String contentProvider, Set<LicenseDocuments> licenseDocuments, Set<CustomLicFieldValue> customLicFieldValues, Set<LicenseDetails> licenseDetails, Boolean allAssets, Set<SmAssets> smAssets) {
        this.licenseType = licenseType;
        this.deal = deal;
        this.name = name;
        this.active = active;
        this.creationDate = creationDate;
        this.effectiveDate = effectiveDate;
        this.expiryDate = expiryDate;
        this.notes = notes;
        this.contentProvider = contentProvider;
        this.licenseDocuments = licenseDocuments;
        this.licenseCustomLicFieldValues = customLicFieldValues;
        this.licenseDetails = licenseDetails;
        this.allAssets = allAssets;
        this.smAssets = smAssets;
    }

    @Id
    @Column(name="ID_LICENSE", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="LicenseID Sequence Generator", sequenceName="CM_LICENSE_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="LicenseID Sequence Generator")
    public Long getIdLicense() {
        return this.idLicense;
    }

    public void setIdLicense(Long idLicense) {
        this.idLicense = idLicense;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TYPE", nullable=false)
    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DEAL", nullable=false)
    public Deal getDeal() {
        return this.deal;
    }

    public void setDeal(Deal deal) {
        this.deal = deal;
    }

    @Column(name="NAME", unique=true, nullable=false, length=50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Type(type="yes_no")
    @Column(name="ACTIVE", nullable=false, length=1)
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CREATION_DATE", nullable=false)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EFFECTIVE_DATE", nullable=false)
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EXPIRY_DATE", nullable=false)
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Column(name="NOTES", nullable=true, length=250)
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Column(name="CONTENT_PROVIDER", nullable=true, length=500)
    public String getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(String contentProvider) {
        this.contentProvider = contentProvider;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="license", cascade={CascadeType.ALL})
    public Set<LicenseDocuments> getLicenseDocuments() {
        return this.licenseDocuments;
    }

    public void setLicenseDocuments(Set<LicenseDocuments> licenseDocuments) {
        this.licenseDocuments = licenseDocuments;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LICENSE")
    public Set<CustomLicFieldValue> getLicenseCustomLicFieldValues() {
        return this.licenseCustomLicFieldValues;
    }

    public void setLicenseCustomLicFieldValues(Set<CustomLicFieldValue> customLicFieldValues) {
        this.licenseCustomLicFieldValues = customLicFieldValues;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="LICENSE_ID_LICENSE", nullable=false)
    public Set<LicenseDetails> getLicenseDetails() {
        return this.licenseDetails;
    }

    public void setLicenseDetails(Set<LicenseDetails> licenseDetails) {
        this.licenseDetails = licenseDetails;
    }

    @Type(type="yes_no")
    @Column(name="ALL_ASSETS", nullable=false, length=1)
    public Boolean getAllAssets() {
        return this.allAssets;
    }

    public void setAllAssets(Boolean allAssets) {
        this.allAssets = allAssets;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="license")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<SmAssets> getSmAssets() {
        return this.smAssets;
    }

    public void setSmAssets(Set<SmAssets> smAssets) {
        this.smAssets = smAssets;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="UPDATEDATE", nullable=false)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Column(name="EXTERNAL_ID", unique=true, nullable=true, length=100)
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }
}

