/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.extended_interface.impl;

import com.ericsson.ejb.Currency;
import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.Field;
import com.ericsson.ejb.Frequency;
import com.ericsson.ejb.License;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.enumeration.FieldIdentifier;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.extended_interface.IRulesLicenseWrapper;
import com.ericsson.extended_interface.impl.RulesLicensingField;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Stateless;

@Local(value={IRulesLicenseWrapper.class})
@Stateless
public class RulesLicenseWrapper
implements IRulesLicenseWrapper {
    private License license;
    private Long siteId;
    List<RulesLicensingField> customFieldList;
    private List<Frequency> frequencyList;
    private List<Currency> currencyList;

    public License getLicense() {
        return this.license;
    }

    public RulesLicenseWrapper(License license, Long siteId, List<RulesLicensingField> fieldsList, List<Frequency> frequencyList, List<Currency> currencyList) {
        this.license = license;
        this.siteId = siteId;
        this.customFieldList = fieldsList;
        this.frequencyList = frequencyList;
        this.currencyList = currencyList;
    }

    public boolean isSiteIdNull() {
        return this.siteId == null;
    }

    public List<Object> getFieldValue(String identifier) {
        ArrayList<Object> list = new ArrayList<Object>(0);
        if (this.license == null) {
            return list;
        }
        if (identifier.matches(FieldIdentifier.LICENSE_ID.getDisplayName())) {
            return this.addObjectToList(list, this.license.getIdLicense());
        }
        if (identifier.matches(FieldIdentifier.LICENSE_EFFECTIVE_DATE.getDisplayName())) {
            return this.addObjectToList(list, this.license.getEffectiveDate());
        }
        if (identifier.matches(FieldIdentifier.LICENSE_EXPIRY_DATE.getDisplayName())) {
            return this.addObjectToList(list, this.license.getExpiryDate());
        }
        if (identifier.matches(FieldIdentifier.PRICING_ACTUAL_RETAIL_PRICE.getDisplayName())) {
            if (this.license.getLicenseDetails() != null) {
                for (LicenseDetails details : this.license.getLicenseDetails()) {
                    if ((!this.isSiteIdNull() || details.getDeliveryLocationId() != null) && (this.isSiteIdNull() || details.getDeliveryLocationId() == null || details.getDeliveryLocationId().longValue() != this.siteId.longValue())) continue;
                    return this.addObjectToList(list, details.getPrActualRetailPrice() != null ? Float.valueOf(details.getPrActualRetailPrice().floatValue()) : null);
                }
            }
            return list;
        }
        if (identifier.matches(FieldIdentifier.STORAGE_AND_METADATA_POSTER.getDisplayName())) {
            if (this.license.getLicenseDetails() != null) {
                for (LicenseDetails details : this.license.getLicenseDetails()) {
                    if ((!this.isSiteIdNull() || details.getDeliveryLocationId() != null) && (this.isSiteIdNull() || details.getDeliveryLocationId() == null || details.getDeliveryLocationId().longValue() != this.siteId.longValue())) continue;
                    return this.addObjectToList(list, details.getSmPosterArtRequired());
                }
            }
            return list;
        }
        if (identifier.matches(FieldIdentifier.STORAGE_AND_METADATA_PREVIEW.getDisplayName())) {
            if (this.license.getLicenseDetails() != null) {
                for (LicenseDetails details : this.license.getLicenseDetails()) {
                    if ((!this.isSiteIdNull() || details.getDeliveryLocationId() != null) && (this.isSiteIdNull() || details.getDeliveryLocationId() == null || details.getDeliveryLocationId().longValue() != this.siteId.longValue())) continue;
                    return this.addObjectToList(list, details.getSmPreviewRequired());
                }
            }
            return list;
        }
        return this.findCustomFieldValue(identifier);
    }

    private List<Object> addObjectToList(List<Object> list, Object obj) {
        if (obj != null) {
            list.add(obj);
        }
        return list;
    }

    private List<Object> findCustomFieldValue(String identifier) {
        ArrayList<Object> objList = new ArrayList<Object>(0);
        if (this.license == null) {
            return objList;
        }
        RulesLicensingField field = this.findRulesLicensingField(identifier);
        if (field == null) {
            return objList;
        }
        ScreenName screenName = null;
        long fieldId = -1L;
        String[] temp = null;
        if (identifier.contains("License")) {
            screenName = ScreenName.LICENSE;
            temp = identifier.split("/");
            fieldId = new Long(temp[1]);
        } else if (identifier.contains("Storage and Metadata Management")) {
            screenName = ScreenName.STORAGE_METADATA;
            temp = identifier.split("/");
            fieldId = new Long(temp[1]);
        } else if (identifier.contains("Distribution Management")) {
            screenName = ScreenName.DISTRIBUTION;
            temp = identifier.split("/");
            fieldId = new Long(temp[1]);
        } else if (identifier.contains("Asset Enhancement Management")) {
            screenName = ScreenName.ASSET_ENHANCEMENT;
            temp = identifier.split("/");
            fieldId = new Long(temp[1]);
        }
        switch (screenName) {
            case LICENSE: {
                return this.addObjectToList(objList, this.getCustomFieldValue(this.license.getLicenseCustomLicFieldValues(), fieldId));
            }
            case ASSET_ENHANCEMENT: 
            case DISTRIBUTION: 
            case STORAGE_METADATA: {
                for (LicenseDetails details : this.license.getLicenseDetails()) {
                    if ((!this.isSiteIdNull() || details.getDeliveryLocationId() != null) && (this.isSiteIdNull() || details.getDeliveryLocationId() == null || details.getDeliveryLocationId().longValue() != this.siteId.longValue())) continue;
                    return this.addObjectToList(objList, this.getCustomFieldValue(details.getLicenseDetailsCustomLicFieldValues(), fieldId));
                }
                break;
            }
        }
        return objList;
    }

    private Object getCustomFieldValue(Set<CustomLicFieldValue> customFieldValues, long fieldId) {
        Object fieldValue = null;
        for (CustomLicFieldValue value : customFieldValues) {
            Field field = value.getField();
            if (field.getIdField() != fieldId) continue;
            if (value.getValue() != null) {
                switch (field.getType()) {
                    case Date: {
                        fieldValue = new Date(value.getValue());
                        break;
                    }
                    case Percentage: {
                        fieldValue = new Float(value.getValue());
                        break;
                    }
                    case Number: {
                        fieldValue = new Long(value.getValue());
                        break;
                    }
                    case Frequency: {
                        fieldValue = value.getDisplayableValue(null, this.frequencyList, null);
                        break;
                    }
                    case Currency: {
                        fieldValue = value.getDisplayableValue(this.currencyList, null, null);
                        break;
                    }
                    default: {
                        fieldValue = field.getDropdown() != false ? value.getDisplayableValue(null, null, field.getFieldDropdowns()) : value.getValue();
                    }
                }
            }
            return fieldValue;
        }
        return fieldValue;
    }

    private RulesLicensingField findRulesLicensingField(String identifier) {
        for (RulesLicensingField field : this.customFieldList) {
            if (!field.getFieldIdentifier().equals(identifier)) continue;
            return field;
        }
        return null;
    }
}

