/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.rules.custom;

import com.ericsson.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ChangeProvider
implements CustomNormalizationRule {
    private static String SRC_PROVIDER_ID = "SourceproviderId";

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        RuleResults result = new RuleResults(title);
        String srcProviderId = parameters.get(SRC_PROVIDER_ID).toString();
        Long partnerId = this.getPartnerId(srcProviderId);
        title.setPartnerId(partnerId);
        result.setModified(true);
        return result;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("changeTitleProviderAssociation", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        ArrayList<CustomRuleParameter> variables = new ArrayList<CustomRuleParameter>();
        variables.add(new CustomRuleParameter(SRC_PROVIDER_ID, NameLookup.lookupValue(SRC_PROVIDER_ID, locale), CustomRuleParameter.ParameterDataType.STRING));
        return variables;
    }

    private Long getPartnerId(String providerId) {
        IPartnerManagement partnerManagement = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        Partner sourceOrSelfPartner = partnerManagement.getSourceOrSelfPartner(providerId);
        if (sourceOrSelfPartner == null) {
            throw new RuntimeException("Could not find any source or self partner with providerId " + providerId);
        }
        return sourceOrSelfPartner.getId();
    }
}

