/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.envivio;

import com.tandbergtv.workflow.device.envivio.EnvivioServiceClass;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.AllocationUtility;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.ResourceAllocationStrategy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;

public class EnvivioAllocationStrategy
implements ResourceAllocationStrategy {
    private static final Logger logger = Logger.getLogger(EnvivioAllocationStrategy.class);
    private static long previousTimestmap = System.currentTimeMillis();

    public Resource allocateResource(ResourceGroup arg0) {
        Resource resource = null;
        ArrayList lr = new ArrayList(arg0.getResources());
        Collections.shuffle(lr);
        String url = null;
        for (Resource r : lr) {
            int encoders;
            if (!AllocationUtility.isResourceAvailable((Resource)r) || (encoders = this.getNumEncoderAvailable(url = r.getConnectionString())) <= 0 || !this.isBalancerInstanceStatusStarted(url) || this.getJobQueuedOnEnvivio(url) >= 1) continue;
            resource = r;
            break;
        }
        if (resource == null) {
            logger.warn((Object)"EnvivioAllocationStrategy... no resource available");
        }
        return resource;
    }

    private synchronized boolean isBalancerInstanceStatusStarted(String url) {
        boolean isStarted = false;
        try {
            EnvivioServiceClass stub = new EnvivioServiceClass(url);
            EnvivioServiceClass.GetStatus serverStatus = new EnvivioServiceClass.GetStatus();
            EnvivioServiceClass.GetStatusResponse serverStatusReponse = stub.getStatus(serverStatus);
            if (serverStatusReponse.getStatus().equalsIgnoreCase("started")) {
                isStarted = true;
            }
        }
        catch (AxisFault e) {
            logger.warn((Object)"Failed to get job queue", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Failed to get job queue", (Throwable)e);
        }
        if (!isStarted) {
            logger.warn((Object)"Envivio server not started");
        }
        return isStarted;
    }

    private synchronized int getJobQueuedOnEnvivio(String url) {
        int concurentJobSent = 0;
        try {
            EnvivioServiceClass stub = new EnvivioServiceClass(url);
            long timestamp = System.currentTimeMillis();
            if (timestamp - previousTimestmap < 7500L) {
                Thread.sleep(7500L - (timestamp - previousTimestmap));
                timestamp = System.currentTimeMillis();
            }
            previousTimestmap = timestamp;
            EnvivioServiceClass.GetJobStateSummary request = new EnvivioServiceClass.GetJobStateSummary();
            EnvivioServiceClass.GetJobStateSummaryResponse response = stub.getJobStateSummary(request);
            EnvivioServiceClass.Jobstatesummarylist list = response.getStates();
            if (list.getState() != null) {
                for (EnvivioServiceClass.Jobstatesummary j : list.getState()) {
                    if (!j.getName().equalsIgnoreCase("queued")) continue;
                    concurentJobSent = j.getCount();
                }
            }
        }
        catch (AxisFault e) {
            concurentJobSent = Integer.MAX_VALUE;
            logger.warn((Object)"Failed to get job queue", (Throwable)e);
        }
        catch (RemoteException e) {
            concurentJobSent = Integer.MAX_VALUE;
            logger.warn((Object)"Failed to get job queue", (Throwable)e);
        }
        catch (InterruptedException ex) {
            concurentJobSent = Integer.MAX_VALUE;
            logger.warn((Object)"Failed sleep currentThread", (Throwable)ex);
        }
        return concurentJobSent;
    }

    private synchronized int getNumEncoderAvailable(String url) {
        int encoder = 0;
        try {
            EnvivioServiceClass stub = new EnvivioServiceClass(url);
            EnvivioServiceClass.GetAllResources resource = new EnvivioServiceClass.GetAllResources();
            EnvivioServiceClass.GetAllResourcesResponse resourcesResponse = stub.getAllResources(resource);
            EnvivioServiceClass.Resourcelist list = resourcesResponse.getResources();
            EnvivioServiceClass.Resource[] resArr = list.getResource();
            if (resArr != null) {
                encoder = resArr.length;
                logger.debug((Object)("Encoder available: " + encoder));
            } else {
                logger.warn((Object)"No encoder available");
                encoder = 0;
            }
        }
        catch (AxisFault e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return encoder;
    }
}

