/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmatchers.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xmlmatchers.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityTransformer {
    private TransformerFactory transformerFactory;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, String> outputProperties = new HashMap<String, String>();

    public IdentityTransformer() {
        this.transformerFactory = this.newTransformerFactory();
    }

    public IdentityTransformer(TransformerFactory transformerFactory) {
        if (transformerFactory == null) {
            throw new IllegalArgumentException("The TransformerFactory cannot be null");
        }
        this.transformerFactory = transformerFactory;
    }

    public IdentityTransformer(TransformerFactory transformerFactory, Map<String, Object> parameters) {
        this(transformerFactory);
        this.parameters.putAll(parameters);
    }

    private TransformerFactory newTransformerFactory() {
        return this.newTransformerFactory(null);
    }

    private TransformerFactory newTransformerFactory(Class<TransformerFactory> transformerFactoryClass) {
        if (transformerFactoryClass != null) {
            try {
                return transformerFactoryClass.newInstance();
            }
            catch (Exception ex) {
                throw new TransformerFactoryConfigurationError(ex, "Could not instantiate TransformerFactory");
            }
        }
        return TransformerFactory.newInstance();
    }

    private final Transformer createTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.transformerFactory.newTransformer();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.outputProperties.entrySet()) {
            transformer.setOutputProperty(entry.getKey(), (String)entry.getValue());
        }
        return transformer;
    }

    public final void transform(Source source, Result result) throws TransformerException {
        try {
            Transformer transformer = this.createTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerException(e);
        }
        catch (javax.xml.transform.TransformerException e) {
            throw new TransformerException(e);
        }
    }

    public final void transform(Source source, Result result, Map<String, Object> parameters) throws TransformerException {
        try {
            Transformer transformer = this.createTransformer();
            if (parameters != null) {
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerException(e);
        }
        catch (javax.xml.transform.TransformerException e) {
            throw new TransformerException(e);
        }
    }
}

