/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.boot;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EngineDriverProperties
extends Properties {
    private static final long serialVersionUID = 1991050875737707033L;
    private static final String DRIVER_PROPERTIES_FILE = "engineDriver.properties";
    private static final String WORKFLOW_FOLDER_NAME = "workflow";
    private String filePath;
    private static final Logger logger = Logger.getLogger(EngineDriverProperties.class);

    public EngineDriverProperties() {
        String configPath = null;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            configPath = properties.getProperty("WorkflowApp.ConfigPath");
            if (configPath != null) {
                configPath = configPath.trim();
            }
        }
        catch (IOException ioe) {
            String msg = "Cannot store: engineDriver.properties, failed to read the Application Properties and read value for key: WorkflowApp.ConfigPath";
            logger.error((Object)msg, (Throwable)ioe);
        }
        if (configPath != null && configPath.length() > 0) {
            this.filePath = configPath + File.separator + DRIVER_PROPERTIES_FILE;
            IConfigurationService configReaderService = (IConfigurationService)ServiceRegistry.getDefault().lookup("Configuration Admin");
            File driverPropertiesFile = configReaderService.getFile(WORKFLOW_FOLDER_NAME, DRIVER_PROPERTIES_FILE);
            logger.debug((Object)("The Driver Properties File: " + driverPropertiesFile.getAbsolutePath()));
            if (!driverPropertiesFile.exists()) {
                try {
                    this.save();
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to write properties to the Engine Driver Properties file: " + this.getPropertiesFilePath()), (Throwable)ex);
                }
            } else {
                try {
                    this.load();
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to read any existing Engine Driver Properties file: " + this.getPropertiesFilePath() + ", using default property values."), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public String getProperty(String key) {
        if ("driver.properties.file".equals(key)) {
            return this.filePath;
        }
        return super.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load() throws IOException {
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(new File(this.filePath));
            this.load(inStream);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to close the Engine Driver Properties File Stream.", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void save() throws IOException {
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(this.filePath));
            this.store(out, null);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to close the Engine Driver Properties File Stream.", (Throwable)ex);
                }
            }
        }
    }

    private String getPropertiesFilePath() {
        return this.filePath;
    }
}

