/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.IProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.driver.template.event.TemplateEvent;
import com.tandbergtv.workflow.driver.template.event.TemplateEvents;
import java.io.File;
import org.apache.log4j.Logger;

public abstract class AbstractFileListener
implements IProcess {
    private static final Logger logger = Logger.getLogger(AbstractFileListener.class);

    protected AbstractFileListener() {
    }

    public void fileCreated(FileInfo fileInfo) {
        String path = fileInfo.getAbsolutePath();
        File file = new File(path);
        this.preCreate(file);
        WorkflowTemplate template = null;
        try {
            template = this.read(file);
            logger.debug((Object)("Loaded template " + template));
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TemplateEvent((Object)file, template, TemplateEvents.COMPILED));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to ingest template " + path), (Throwable)e);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TemplateEvent((Object)file, template, TemplateEvents.COMPILE_ERROR));
        }
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.warn((Object)"Ignoring file deleted event");
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.warn((Object)"Ignoring file updated event");
    }

    protected void preCreate(File file) {
        logger.debug((Object)("New file " + file.getAbsolutePath()));
    }

    protected abstract WorkflowTemplate read(File var1);
}

