/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.impl;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.DefaultMessageKeyGenerator;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

public class WorkflowMessageFactoryImpl
extends WorkflowMessageFactory {
    private static final Logger logger = Logger.getLogger(WorkflowMessageFactoryImpl.class);

    protected WorkflowMessage createControlMessageImpl(String uid) {
        MessageUIDImpl messageUid = new MessageUIDImpl(uid);
        WorkflowMessage message = this.createWorkflowMessageImpl((IMessageUID)messageUid, null, WorkflowMessage.MessageType.control);
        message.setResponseDestination(this.createResponseDestination());
        return message;
    }

    protected WorkflowMessage createControlMessageImpl(String uid, ExecutionContext ec) {
        IMessageKey key = this.createMessageKey(ec);
        MessageUIDImpl messageUid = new MessageUIDImpl(uid);
        WorkflowMessage message = this.createWorkflowMessageImpl((IMessageUID)messageUid, key, WorkflowMessage.MessageType.control);
        message.setResponseDestination(this.createResponseDestination());
        return message;
    }

    protected WorkflowMessage createWorkflowMessageImpl(IMessageUID uid, IMessageKey key, WorkflowMessage.MessageType type) {
        WorkflowMessage message = new WorkflowMessage(uid, key, type);
        message.setSource(this.createSource());
        logger.debug((Object)("Creating Message with UID: " + uid.getUID()));
        return message;
    }

    private ISource createSource() {
        return (ISource)DeviceTypeUtil.createWorkflowDevice();
    }

    private IDestination createResponseDestination() {
        logger.debug((Object)"Creating the response destination...");
        IDestination responseDestination = null;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            String connectionType = properties.getProperty("ResponseDestination.ConnectionType");
            String connectionString = properties.getProperty("ResponseDestination.ConnectionString");
            responseDestination = (IDestination)DeviceTypeUtil.createDevice(connectionType, connectionString);
        }
        catch (Exception ex) {
            throw new RuntimeException("Response destination cannot be set", ex);
        }
        return responseDestination;
    }

    private IMessageKey createMessageKey(ExecutionContext ec) {
        DefaultMessageKeyGenerator keyGenStrategy = new DefaultMessageKeyGenerator();
        IMessageKey key = keyGenStrategy.generate(ec.getToken());
        logger.debug((Object)("Message Key Created: " + key));
        return key;
    }
}

