/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.usermgmt.service.IUserValidityService;
import com.tandbergtv.neptune.usermgmt.service.UserValidationException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.util.ArrayList;
import java.util.Set;

public class UserValidityService
implements IUserValidityService {
    public void validate(User user) throws UserValidationException {
        ResourceManagement resourceManagement = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        if (user.getUserName() != null) {
            Resource resource = resourceManagement.getResourceByUser(user.getUserName());
            if (resource == null) {
                return;
            }
            for (Role role : user.getRoles()) {
                this.validateRole(role);
            }
        }
    }

    private void validateRole(Role role) throws UserValidationException {
        Set permissions = role.getPermissions();
        ArrayList<String> permissionNames = new ArrayList<String>();
        String moduleName = "UserTasks";
        String permissionName = "PerformTask";
        for (Permission perm : permissions) {
            if (!perm.getModule().getName().equals(moduleName)) continue;
            permissionNames.add(perm.getName());
        }
        if (!permissionNames.contains(permissionName)) {
            throw new UserValidationException("The selected role must contain '" + moduleName + "'-'" + permissionName + "' permission.");
        }
    }
}

