/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.jboss.resteasy.plugins.cache.server.ServerCache;
import org.jboss.resteasy.plugins.cache.server.ServerCacheHitInterceptor;
import org.jboss.resteasy.plugins.cache.server.ServerCacheInterceptor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCache
implements ServerCache {
    protected int maxSize = 100;
    protected long wakeupInterval = 5000L;
    protected Cache cache;
    protected ResteasyProviderFactory providerFactory;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public long getWakeupInterval() {
        return this.wakeupInterval;
    }

    public void setWakeupInterval(long wakeupInterval) {
        this.wakeupInterval = wakeupInterval;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void start() {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        ExpirationAlgorithmConfig exp = new ExpirationAlgorithmConfig();
        exp.setMaxNodes(this.maxSize);
        EvictionRegionConfig evictionRegionConfig = new EvictionRegionConfig(RegionManagerImpl.DEFAULT_REGION);
        evictionRegionConfig.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)exp);
        EvictionConfig evictConfig = new EvictionConfig();
        evictConfig.setDefaultEvictionRegionConfig(evictionRegionConfig);
        evictConfig.setWakeupInterval(this.wakeupInterval);
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        config.setEvictionConfig(evictConfig);
        this.cache = factory.createCache(config, true);
        ServerCacheHitInterceptor hit = new ServerCacheHitInterceptor(this);
        ServerCacheInterceptor interceptor = new ServerCacheInterceptor(this);
        this.getProviderFactory().getServerPreProcessInterceptorRegistry().register((Object)hit);
        this.getProviderFactory().getServerMessageBodyWriterInterceptorRegistry().register((Object)interceptor);
    }

    public void stop() {
        this.cache.stop();
    }

    @Override
    public ServerCache.Entry get(String uri, MediaType accept) {
        Node parent = this.cache.getRoot().getChild(Fqn.fromElements((Object[])new String[]{uri}));
        if (parent == null) {
            return null;
        }
        for (Object obj : parent.getChildren()) {
            Node leaf = (Node)obj;
            CacheEntry entry = (CacheEntry)leaf.get((Object)"entry");
            if (!accept.isCompatible(entry.getMediaType())) continue;
            return (ServerCache.Entry)leaf.get((Object)"entry");
        }
        return null;
    }

    @Override
    public ServerCache.Entry add(String uri, MediaType mediaType, CacheControl cc, MultivaluedMap<String, Object> headers, byte[] entity, String etag) {
        System.out.println("adding...");
        Node parent = this.cache.getRoot().addChild(Fqn.fromElements((Object[])new String[]{uri}));
        Node leaf = parent.addChild(Fqn.fromElements((Object[])new String[]{mediaType.toString()}));
        leaf.put((Object)"expiration", (Object)((long)(cc.getMaxAge() * 1000) + System.currentTimeMillis()));
        CacheEntry cacheEntry = new CacheEntry(headers, entity, cc.getMaxAge(), etag, mediaType);
        leaf.put((Object)"entry", (Object)cacheEntry);
        return cacheEntry;
    }

    @Override
    public void remove(String key) {
    }

    @Override
    public void clear() {
        this.cache.clearData(Fqn.ROOT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheEntry
    implements ServerCache.Entry {
        private final byte[] cached;
        private final int expires;
        private final long timestamp = System.currentTimeMillis();
        private final MultivaluedMap<String, Object> headers;
        private String etag;
        private MediaType mediaType;

        private CacheEntry(MultivaluedMap<String, Object> headers, byte[] cached, int expires, String etag, MediaType mediaType) {
            this.cached = cached;
            this.expires = expires;
            this.headers = headers;
            this.etag = etag;
            this.mediaType = mediaType;
        }

        @Override
        public int getExpirationInSeconds() {
            return this.expires - (int)((System.currentTimeMillis() - this.timestamp) / 1000L);
        }

        @Override
        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp >= (long)(this.expires * 1000);
        }

        @Override
        public String getEtag() {
            return this.etag;
        }

        @Override
        public MultivaluedMap<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public byte[] getCached() {
            return this.cached;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }
    }
}

