/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.resteasy.plugins.cache.server.JBossCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ServletServerCache
implements ServletContextListener {
    protected ResteasyProviderFactory providerFactory;
    protected JBossCache cache = new JBossCache();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        String wakeupInterval;
        ServletContext servletContext = servletContextEvent.getServletContext();
        this.providerFactory = (ResteasyProviderFactory)servletContext.getAttribute(ResteasyProviderFactory.class.getName());
        if (this.providerFactory == null) {
            throw new RuntimeException("Resteasy is not intialized, could not find ResteasyProviderFactory attribute");
        }
        String maxSize = servletContext.getInitParameter("resteasy.server.cache.maxsize");
        if (maxSize != null) {
            this.cache.setMaxSize(Integer.parseInt(maxSize));
        }
        if ((wakeupInterval = servletContext.getInitParameter("resteasy.server.cache.eviction.wakeup.interval")) != null) {
            this.cache.setWakeupInterval(Long.parseLong(wakeupInterval));
        }
        this.cache.setProviderFactory(this.providerFactory);
        this.cache.start();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.cache.stop();
    }
}

