/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class GossipRouter {
    public static final byte CONNECT = 1;
    public static final byte DISCONNECT = 2;
    public static final byte REGISTER = 3;
    public static final byte GOSSIP_GET = 4;
    public static final byte ROUTER_GET = 5;
    public static final byte GET_RSP = 6;
    public static final byte UNREGISTER = 7;
    public static final byte DUMP = 8;
    public static final byte SHUTDOWN = 9;
    public static final int PORT = 12001;
    public static final long EXPIRY_TIME = 30000L;
    public static final long GOSSIP_REQUEST_TIMEOUT = 1000L;
    public static final long ROUTING_CLIENT_REPLY_TIMEOUT = 120000L;
    private int port;
    private String bindAddressString;
    private long expiryTime;
    private long gossipRequestTimeout;
    private long routingClientReplyTimeout;
    private final ConcurrentMap<String, ConcurrentMap<Address, AddressEntry>> routingTable = new ConcurrentHashMap<String, ConcurrentMap<Address, AddressEntry>>();
    private ServerSocket srvSock = null;
    private InetAddress bindAddress = null;
    private long linger_timeout = 2000L;
    private long sock_read_timeout = 3000L;
    private int backlog = 1000;
    private boolean up = true;
    private boolean discard_loopbacks = false;
    Timer timer = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    private static int threadCounter = 0;

    public GossipRouter() {
        this(12001);
    }

    public GossipRouter(int port) {
        this(port, null);
    }

    public GossipRouter(int port, String bindAddressString) {
        this(port, bindAddressString, 30000L);
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime) {
        this(port, bindAddressString, expiryTime, 1000L, 120000L);
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime, long gossipRequestTimeout, long routingClientReplyTimeout) {
        this.port = port;
        this.bindAddressString = bindAddressString;
        this.expiryTime = expiryTime;
        this.gossipRequestTimeout = gossipRequestTimeout;
        this.routingClientReplyTimeout = routingClientReplyTimeout;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddressString = bindAddress;
    }

    public String getBindAddress() {
        return this.bindAddressString;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setGossipRequestTimeout(long gossipRequestTimeout) {
        this.gossipRequestTimeout = gossipRequestTimeout;
    }

    public long getGossipRequestTimeout() {
        return this.gossipRequestTimeout;
    }

    public void setRoutingClientReplyTimeout(long routingClientReplyTimeout) {
        this.routingClientReplyTimeout = routingClientReplyTimeout;
    }

    public long getRoutingClientReplyTimeout() {
        return this.routingClientReplyTimeout;
    }

    public boolean isStarted() {
        return this.srvSock != null;
    }

    public boolean isDiscardLoopbacks() {
        return this.discard_loopbacks;
    }

    public void setDiscardLoopbacks(boolean discard_loopbacks) {
        this.discard_loopbacks = discard_loopbacks;
    }

    public long getLingerTimeout() {
        return this.linger_timeout;
    }

    public void setLingerTimeout(long linger_timeout) {
        this.linger_timeout = linger_timeout;
    }

    public long getSocketReadTimeout() {
        return this.sock_read_timeout;
    }

    public void setSocketReadTimeout(long sock_read_timeout) {
        this.sock_read_timeout = sock_read_timeout;
    }

    public static String type2String(int type) {
        switch (type) {
            case 1: {
                return "CONNECT";
            }
            case 2: {
                return "DISCONNECT";
            }
            case 3: {
                return "REGISTER";
            }
            case 4: {
                return "GOSSIP_GET";
            }
            case 5: {
                return "ROUTER_GET";
            }
            case 6: {
                return "GET_RSP";
            }
            case 7: {
                return "UNREGISTER";
            }
            case 8: {
                return "DUMP";
            }
            case 9: {
                return "SHUTDOWN";
            }
        }
        return "unknown";
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
        if (this.srvSock != null) {
            throw new Exception("Router already started.");
        }
        if (this.bindAddressString != null) {
            this.bindAddress = InetAddress.getByName(this.bindAddressString);
            this.srvSock = new ServerSocket(this.port, this.backlog, this.bindAddress);
        } else {
            this.srvSock = new ServerSocket(this.port, this.backlog);
        }
        this.up = true;
        new Thread(new Runnable(){

            public void run() {
                GossipRouter.this.mainLoop();
                GossipRouter.this.cleanup();
            }
        }, "GossipRouter").start();
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                GossipRouter.this.sweep();
            }
        }, this.expiryTime, this.expiryTime);
    }

    public void stop() {
        block5: {
            this.up = false;
            if (this.srvSock == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"router already stopped");
                }
                return;
            }
            this.timer.cancel();
            this.shutdown();
            try {
                this.srvSock.close();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error((Object)("Failed to close server socket: " + e));
            }
        }
        this.srvSock = null;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"router stopped");
        }
    }

    public void destroy() {
    }

    public String dumpRoutingTable() {
        String label = "routing";
        StringBuilder sb = new StringBuilder();
        if (this.routingTable.isEmpty()) {
            sb.append("empty ").append(label).append(" table");
        } else {
            for (String gname : this.routingTable.keySet()) {
                sb.append("GROUP: '" + gname + "'\n");
                Map map = (Map)this.routingTable.get(gname);
                if (map == null) {
                    sb.append("\tnull list of addresses\n");
                    continue;
                }
                if (map.isEmpty()) {
                    sb.append("\tempty list of addresses\n");
                    continue;
                }
                for (AddressEntry ae : map.values()) {
                    sb.append('\t').append(ae).append('\n');
                }
            }
        }
        return sb.toString();
    }

    private void mainLoop() {
        Socket sock = null;
        DataInputStream input = null;
        DataOutputStream output = null;
        IpAddress peer_addr = null;
        if (this.bindAddress == null) {
            this.bindAddress = this.srvSock.getInetAddress();
        }
        System.out.println("GossipRouter started at " + new Date() + "\nListening on port " + this.port + " bound on address " + this.bindAddress + '\n');
        block12: while (this.up && this.srvSock != null) {
            try {
                sock = this.srvSock.accept();
                if (this.linger_timeout > 0L) {
                    int linger = Math.min(1, (int)(this.linger_timeout / 1000L));
                    sock.setSoLinger(true, linger);
                }
                if (this.sock_read_timeout > 0L) {
                    sock.setSoTimeout((int)this.sock_read_timeout);
                }
                input = new DataInputStream(sock.getInputStream());
                GossipData req = new GossipData();
                req.readFrom(input);
                switch (req.getType()) {
                    case 3: {
                        Address mbr = req.getAddress();
                        String group = req.getGroup();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("REGISTER(" + group + ", " + mbr + ")"));
                        }
                        if (group == null || mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"group or member is null, cannot register member");
                            }
                        } else {
                            this.addGossipEntry(group, mbr, new AddressEntry(mbr));
                        }
                        Util.close(input);
                        Util.close(sock);
                        continue block12;
                    }
                    case 7: {
                        Address mbr = req.getAddress();
                        String group = req.getGroup();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("UNREGISTER(" + group + ", " + mbr + ")"));
                        }
                        if (group == null || mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"group or member is null, cannot unregister member");
                            }
                        } else {
                            this.removeGossipEntry(group, mbr);
                        }
                        Util.close(input);
                        Util.close(output);
                        Util.close(sock);
                        continue block12;
                    }
                    case 4: {
                        String group = req.getGroup();
                        LinkedList mbrs = null;
                        Map map = (Map)this.routingTable.get(group);
                        if (map != null) {
                            mbrs = new LinkedList(map.keySet());
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("GOSSIP_GET(" + group + ") --> " + mbrs));
                        }
                        output = new DataOutputStream(sock.getOutputStream());
                        GossipData rsp = new GossipData(6, group, null, mbrs);
                        rsp.writeTo(output);
                        Util.close(input);
                        Util.close(output);
                        Util.close(sock);
                        continue block12;
                    }
                    case 5: {
                        String group = req.getGroup();
                        output = new DataOutputStream(sock.getOutputStream());
                        LinkedList<Object> ret = null;
                        Map map = (Map)this.routingTable.get(group);
                        ret = map != null ? new LinkedList(map.keySet()) : new LinkedList();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("ROUTER_GET(" + group + ") --> " + ret));
                        }
                        GossipData rsp = new GossipData(6, group, null, ret);
                        rsp.writeTo(output);
                        Util.close(input);
                        Util.close(output);
                        Util.close(sock);
                        continue block12;
                    }
                    case 8: {
                        output = new DataOutputStream(sock.getOutputStream());
                        output.writeUTF(this.dumpRoutingTable());
                        Util.close(input);
                        Util.close(output);
                        Util.close(sock);
                        continue block12;
                    }
                    case 1: {
                        sock.setSoTimeout(0);
                        output = new DataOutputStream(sock.getOutputStream());
                        peer_addr = new IpAddress(sock.getInetAddress(), sock.getPort());
                        Address logical_addr = req.getAddress();
                        String group_name = req.getGroup();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("CONNECT(" + group_name + ", " + logical_addr + ")"));
                        }
                        SocketThread st = new SocketThread(sock, input, group_name, logical_addr);
                        this.addEntry(group_name, logical_addr, new AddressEntry(logical_addr, peer_addr, sock, st, output));
                        st.start();
                        continue block12;
                    }
                    case 2: {
                        Address addr = req.getAddress();
                        String group_name = req.getGroup();
                        this.removeEntry(group_name, addr);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("DISCONNECT(" + group_name + ", " + addr + ")"));
                        }
                        Util.close(input);
                        Util.close(output);
                        Util.close(sock);
                        continue block12;
                    }
                    case 9: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"router shutting down");
                        }
                        Util.close(input);
                        Util.close(output);
                        Util.close(sock);
                        this.up = false;
                        continue block12;
                    }
                }
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)("received unkown gossip request (gossip=" + req + ')'));
            }
            catch (Exception e) {
                if (this.up && this.log.isErrorEnabled()) {
                    this.log.error((Object)"failure handling a client request", (Throwable)e);
                }
                Util.close(input);
                Util.close(output);
                Util.close(sock);
            }
        }
    }

    private void cleanup() {
        for (ConcurrentMap map : this.routingTable.values()) {
            if (map == null) continue;
            for (AddressEntry entry : map.values()) {
                entry.destroy();
            }
        }
        this.routingTable.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        block6: {
            Socket s = null;
            DataOutputStream dos = null;
            try {
                s = new Socket(this.srvSock.getInetAddress(), this.srvSock.getLocalPort());
                dos = new DataOutputStream(s.getOutputStream());
                dos.writeInt(9);
                dos.writeUTF("");
                Util.close(s);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("shutdown failed: " + e));
                }
                break block6;
            }
            finally {
                Util.close(s);
                Util.close(dos);
            }
            Util.close(dos);
        }
    }

    private void sweep() {
        long currentTime = System.currentTimeMillis();
        int num_entries_removed = 0;
        Iterator it = this.routingTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Map map = (Map)entry.getValue();
            if (map == null || map.isEmpty()) {
                it.remove();
                continue;
            }
            Iterator it2 = map.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry2 = it2.next();
                AddressEntry ae = (AddressEntry)entry2.getValue();
                long diff = currentTime - ae.timestamp;
                if (diff <= this.expiryTime) continue;
                it2.remove();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("removed " + ae.logical_addr + " (" + diff + " msecs old)"));
                }
                ++num_entries_removed;
            }
        }
        if (num_entries_removed > 0 && this.log.isTraceEnabled()) {
            this.log.trace((Object)("done (removed " + num_entries_removed + " entries)"));
        }
    }

    private void route(Address dest, String dest_group, byte[] msg, Address sender) {
        if (dest == null) {
            if (dest_group == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"both dest address and group are null");
                }
            } else {
                this.sendToAllMembersInGroup(dest_group, msg, sender);
            }
        } else {
            AddressEntry ae = this.findAddressEntry(dest_group, dest);
            if (ae == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("cannot find " + dest + " in the routing table, \nrouting table=\n" + this.dumpRoutingTable()));
                }
                return;
            }
            if (ae.output == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)(dest + " is associated with a null output stream"));
                }
                return;
            }
            try {
                this.sendToMember(dest, ae.output, msg, sender);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("failed sending message to " + dest + ": " + e.getMessage()));
                }
                this.removeEntry(dest_group, dest);
            }
        }
    }

    private void addEntry(String groupname, Address logical_addr, AddressEntry entry) {
        this.addEntry(groupname, logical_addr, entry, false);
    }

    private void addEntry(String groupname, Address logical_addr, AddressEntry entry, boolean update_only) {
        if (groupname == null || logical_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"groupname or logical_addr was null, entry was not added");
            }
            return;
        }
        ConcurrentHashMap<Address, AddressEntry> mbrs = (ConcurrentHashMap<Address, AddressEntry>)this.routingTable.get(groupname);
        if (mbrs == null) {
            mbrs = new ConcurrentHashMap<Address, AddressEntry>();
            mbrs.put(logical_addr, entry);
            this.routingTable.putIfAbsent(groupname, mbrs);
        } else {
            AddressEntry tmp = (AddressEntry)mbrs.get(logical_addr);
            if (tmp != null) {
                if (update_only) {
                    tmp.update();
                    return;
                }
                tmp.destroy();
            }
            mbrs.put(logical_addr, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(String groupname, Address logical_addr) {
        Map val = (Map)this.routingTable.get(groupname);
        if (val == null) {
            return;
        }
        Map map = val;
        synchronized (map) {
            AddressEntry entry = (AddressEntry)val.get(logical_addr);
            if (entry != null) {
                entry.destroy();
                val.remove(logical_addr);
            }
        }
    }

    private AddressEntry findAddressEntry(String group_name, Address logical_addr) {
        if (group_name == null || logical_addr == null) {
            return null;
        }
        Map val = (Map)this.routingTable.get(group_name);
        if (val == null) {
            return null;
        }
        return (AddressEntry)val.get(logical_addr);
    }

    private void addGossipEntry(String groupname, Address logical_addr, AddressEntry e) {
        this.addEntry(groupname, logical_addr, e, true);
    }

    private void removeGossipEntry(String groupname, Address mbr) {
        this.removeEntry(groupname, mbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToAllMembersInGroup(String groupname, byte[] msg, Address sender) {
        Map val = (Map)this.routingTable.get(groupname);
        if (val == null || val.isEmpty()) {
            return;
        }
        Map map = val;
        synchronized (map) {
            Iterator i = val.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry tmp = i.next();
                AddressEntry entry = (AddressEntry)tmp.getValue();
                DataOutputStream dos = entry.output;
                if (dos == null) continue;
                try {
                    this.sendToMember(null, dos, msg, sender);
                }
                catch (Exception e) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("cannot send to " + entry.logical_addr + ": " + e.getMessage()));
                    }
                    entry.destroy();
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToMember(Address dest, DataOutputStream out, byte[] msg, Address sender) throws IOException {
        if (out == null) {
            return;
        }
        if (this.discard_loopbacks && dest != null && dest.equals(sender)) {
            return;
        }
        DataOutputStream dataOutputStream = out;
        synchronized (dataOutputStream) {
            Util.writeAddress(dest, out);
            out.writeInt(msg.length);
            out.write(msg, 0, msg.length);
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 12001;
        long expiry = 30000L;
        long timeout = 1000L;
        long routingTimeout = 120000L;
        GossipRouter router = null;
        String bind_addr = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-bindaddress".equals(arg) || "-bind_addr".equals(arg)) {
                bind_addr = args[++i];
                continue;
            }
            if ("-expiry".equals(arg)) {
                expiry = Long.parseLong(args[++i]);
                continue;
            }
            if ("-timeout".equals(arg)) {
                timeout = Long.parseLong(args[++i]);
                continue;
            }
            if ("-rtimeout".equals(arg)) {
                routingTimeout = Long.parseLong(args[++i]);
                continue;
            }
            GossipRouter.help();
            return;
        }
        System.out.println("GossipRouter is starting...");
        try {
            ClassConfigurator.getInstance(true);
            router = new GossipRouter(port, bind_addr, expiry, timeout, routingTimeout);
            router.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println();
        System.out.println("GossipRouter [-port <port>] [-bind_addr <address>] [options]");
        System.out.println("Options: ");
        System.out.println("        -expiry <msecs>   - Time until a gossip cache entry expires.");
        System.out.println("        -timeout <msecs>  - Number of millisecs the router waits to receive");
        System.out.println("                            a gossip request after connection was established;");
        System.out.println("                            upon expiration, the router initiates the routing");
        System.out.println("                            protocol on the connection.");
    }

    class SocketThread
    extends Thread {
        private volatile boolean active;
        Socket sock;
        DataInputStream input;
        Address logical_addr;
        String group_name;

        public SocketThread(Socket sock, DataInputStream ois, String group_name, Address logical_addr) {
            super(Util.getGlobalThreadGroup(), "SocketThread " + threadCounter++);
            this.active = true;
            this.sock = null;
            this.input = null;
            this.logical_addr = null;
            this.group_name = null;
            this.sock = sock;
            this.input = ois;
            this.group_name = group_name;
            this.logical_addr = logical_addr;
        }

        void closeSocket() {
            Util.close(this.input);
            Util.close(this.sock);
        }

        void finish() {
            this.active = false;
        }

        public void run() {
            Address dst_addr = null;
            while (this.active) {
                byte[] buf;
                String gname;
                try {
                    gname = this.input.readUTF();
                    dst_addr = Util.readAddress(this.input);
                    int len = this.input.readInt();
                    if (len == 0) {
                        if (!GossipRouter.this.log.isWarnEnabled()) continue;
                        GossipRouter.this.log.warn((Object)"received null message");
                        continue;
                    }
                    buf = new byte[len];
                    this.input.readFully(buf, 0, buf.length);
                }
                catch (Exception io_ex) {
                    if (GossipRouter.this.log.isTraceEnabled()) {
                        GossipRouter.this.log.trace((Object)(this.sock.getInetAddress().getHostName() + ':' + this.sock.getPort() + " closed connection; removing it from routing table"));
                    }
                    GossipRouter.this.removeEntry(this.group_name, this.logical_addr);
                    return;
                }
                try {
                    GossipRouter.this.route(dst_addr, gname, buf, this.logical_addr);
                }
                catch (Exception e) {
                    if (!GossipRouter.this.log.isErrorEnabled()) break;
                    GossipRouter.this.log.error((Object)("failed routing request to " + dst_addr), (Throwable)e);
                    break;
                }
            }
            this.closeSocket();
        }
    }

    class AddressEntry {
        Address logical_addr = null;
        Address physical_addr = null;
        Socket sock = null;
        DataOutputStream output = null;
        long timestamp = 0L;
        final SocketThread thread;

        public AddressEntry(Address addr) {
            this(addr, null, null, null, null);
        }

        public AddressEntry(Address logical_addr, Address physical_addr, Socket sock, SocketThread thread, DataOutputStream output) {
            this.logical_addr = logical_addr;
            this.physical_addr = physical_addr;
            this.sock = sock;
            this.thread = thread;
            this.output = output;
            this.timestamp = System.currentTimeMillis();
        }

        void destroy() {
            if (this.thread != null) {
                this.thread.finish();
            }
            Util.close(this.output);
            this.output = null;
            Util.close(this.sock);
            this.sock = null;
            this.timestamp = 0L;
        }

        public void update() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            return other instanceof AddressEntry && this.logical_addr.equals(((AddressEntry)other).logical_addr);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("logical addr=");
            sb.append(this.logical_addr).append(" (").append(this.physical_addr).append(")");
            if (this.timestamp > 0L) {
                long diff = System.currentTimeMillis() - this.timestamp;
                sb.append(", ").append(diff).append(" ms old");
            }
            return sb.toString();
        }
    }
}

