/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOBTest
extends ChannelTestBase {
    private JChannel c1;
    private JChannel c2;
    private ReentrantLock lock;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = this.createChannel();
        this.c1.setOpt(3, false);
        this.c2 = this.createChannel();
        this.c2.setOpt(3, false);
        OOBTest.setOOBPoolSize(this.c2);
        this.c1.connect("OOBMcastTest");
        this.c2.connect("OOBMcastTest");
        View view = this.c2.getView();
        System.out.println("view = " + view);
        OOBTest.assertEquals((String)("view is " + view), (int)2, (int)view.size());
        this.lock = new ReentrantLock();
        this.lock.lock();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
        Util.sleep(1000L);
        Util.close(this.c2, this.c1);
        super.tearDown();
    }

    public void testNonBlockingUnicastOOBMessage() throws ChannelNotConnectedException, ChannelClosedException {
        Address dest = this.c2.getLocalAddress();
        this.send(dest);
    }

    public void testNonBlockingMulticastOOBMessage() throws ChannelNotConnectedException, ChannelClosedException {
        this.send(null);
    }

    public void testRegularAndOOBUnicasts() throws Exception {
        DISCARD discard = new DISCARD();
        ProtocolStack stack = this.c1.getProtocolStack();
        stack.insertProtocol((Protocol)discard, 2, UNICAST.class);
        Address dest = this.c2.getLocalAddress();
        Message m1 = new Message(dest, null, Integer.valueOf(1));
        Message m2 = new Message(dest, null, Integer.valueOf(2));
        m2.setFlag((byte)1);
        Message m3 = new Message(dest, null, Integer.valueOf(3));
        MyReceiver receiver = new MyReceiver();
        this.c2.setReceiver(receiver);
        this.c1.send(m1);
        discard.setDropDownUnicasts(1);
        this.c1.send(m2);
        this.c1.send(m3);
        Util.sleep(500L);
        List<Integer> list = receiver.getMsgs();
        OOBTest.assertEquals((String)("list is " + list), (int)3, (int)list.size());
        OOBTest.assertTrue((list.contains(1) && list.contains(2) && list.contains(3) ? 1 : 0) != 0);
    }

    public void testRegularAndOOBUnicasts2() throws Exception {
        DISCARD discard = new DISCARD();
        ProtocolStack stack = this.c1.getProtocolStack();
        stack.insertProtocol((Protocol)discard, 2, UNICAST.class);
        Address dest = this.c2.getLocalAddress();
        Message m1 = new Message(dest, null, Integer.valueOf(1));
        Message m2 = new Message(dest, null, Integer.valueOf(2));
        m2.setFlag((byte)1);
        Message m3 = new Message(dest, null, Integer.valueOf(3));
        m3.setFlag((byte)1);
        Message m4 = new Message(dest, null, Integer.valueOf(4));
        MyReceiver receiver = new MyReceiver();
        this.c2.setReceiver(receiver);
        this.c1.send(m1);
        discard.setDropDownUnicasts(1);
        this.c1.send(m3);
        discard.setDropDownUnicasts(1);
        this.c1.send(m2);
        this.c1.send(m4);
        Util.sleep(1000L);
        List<Integer> list = receiver.getMsgs();
        System.out.println("list = " + list);
        OOBTest.assertSame((String)("list is " + list), (Object)list.size(), (Object)4);
        OOBTest.assertTrue((list.contains(1) && list.contains(2) && list.contains(3) && list.contains(4) ? 1 : 0) != 0);
    }

    public void testRegularAndOOBMulticasts() throws Exception {
        DISCARD discard = new DISCARD();
        ProtocolStack stack = this.c1.getProtocolStack();
        stack.insertProtocol((Protocol)discard, 2, NAKACK.class);
        this.c1.setOpt(3, false);
        Address dest = null;
        Message m1 = new Message(dest, null, Integer.valueOf(1));
        Message m2 = new Message(dest, null, Integer.valueOf(2));
        m2.setFlag((byte)1);
        Message m3 = new Message(dest, null, Integer.valueOf(3));
        MyReceiver receiver = new MyReceiver();
        this.c2.setReceiver(receiver);
        this.c1.send(m1);
        discard.setDropDownMulticasts(1);
        this.c1.send(m2);
        this.c1.send(m3);
        Util.sleep(1000L);
        List<Integer> list = receiver.getMsgs();
        System.out.println("list = " + list);
        OOBTest.assertEquals((String)("list is " + list), (int)3, (int)list.size());
        OOBTest.assertTrue((list.contains(1) && list.contains(2) && list.contains(3) ? 1 : 0) != 0);
    }

    public void testRandomRegularAndOOBMulticasts() throws Exception {
        DISCARD discard = new DISCARD();
        ProtocolStack stack = this.c1.getProtocolStack();
        stack.insertProtocol((Protocol)discard, 2, NAKACK.class);
        Address dest = null;
        MyReceiver r1 = new MyReceiver();
        MyReceiver r2 = new MyReceiver();
        this.c1.setReceiver(r1);
        this.c2.setReceiver(r2);
        int NUM_MSGS = 100;
        int NUM_THREADS = 10;
        this.send(dest, 100, 10, 0.5, 0.5, discard);
        List<Integer> one = r1.getMsgs();
        List<Integer> two = r2.getMsgs();
        for (int i = 0; i < 20 && (one.size() != 100 || two.size() != 100); ++i) {
            System.out.print(".");
            Util.sleep(1000L);
        }
        System.out.println("");
        OOBTest.check(100, one, two);
    }

    private void send(final Address dest, int num_msgs, int num_threads, final double oob_prob, final double drop_prob, final DISCARD discard) throws Exception {
        boolean multicast;
        boolean bl = multicast = dest == null || dest.isMulticastAddress();
        if (num_threads <= 0) {
            throw new IllegalArgumentException("number of threads <= 0");
        }
        if (num_msgs % num_threads != 0) {
            throw new IllegalArgumentException("number of messages ( " + num_msgs + ") needs to be divisible by " + "the number o threads (" + num_threads + ")");
        }
        if (num_threads > 1) {
            int i;
            final int msgs_per_thread = num_msgs / num_threads;
            Thread[] threads = new Thread[num_threads];
            final AtomicInteger counter = new AtomicInteger(0);
            for (i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(){

                    public void run() {
                        for (int i = 0; i < msgs_per_thread; ++i) {
                            JChannel sender = Util.tossWeightedCoin(0.5) ? OOBTest.this.c1 : OOBTest.this.c2;
                            boolean oob = Util.tossWeightedCoin(oob_prob);
                            boolean drop = Util.tossWeightedCoin(drop_prob);
                            Message msg = new Message(dest, null, Integer.valueOf(counter.getAndIncrement()));
                            if (oob) {
                                msg.setFlag((byte)1);
                            }
                            if (drop) {
                                if (multicast) {
                                    discard.setDropDownMulticasts(1);
                                } else {
                                    discard.setDropDownUnicasts(1);
                                }
                            }
                            try {
                                ((Channel)sender).send(msg);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join(20000L);
            }
            return;
        }
        for (int i = 0; i < num_msgs; ++i) {
            JChannel sender = Util.tossWeightedCoin(0.5) ? this.c1 : this.c2;
            boolean oob = Util.tossWeightedCoin(oob_prob);
            boolean drop = Util.tossWeightedCoin(drop_prob);
            Message msg = new Message(dest, null, Integer.valueOf(i));
            if (oob) {
                msg.setFlag((byte)1);
            }
            if (drop) {
                if (multicast) {
                    discard.setDropDownMulticasts(1);
                } else {
                    discard.setDropDownUnicasts(1);
                }
            }
            ((Channel)sender).send(msg);
        }
    }

    private void send(Address dest) throws ChannelNotConnectedException, ChannelClosedException {
        BlockingReceiver receiver = new BlockingReceiver(this.lock);
        int NUM = 10;
        this.c2.setReceiver(receiver);
        this.c1.send(new Message(dest, null, Long.valueOf(1L)));
        Util.sleep(1000L);
        for (int i = 2; i <= 10; ++i) {
            Message msg = new Message(dest, null, Long.valueOf(i));
            msg.setFlag((byte)1);
            this.c1.send(msg);
        }
        Util.sleep(1000L);
        List<Long> list = receiver.getMsgs();
        System.out.println("list = " + list);
        OOBTest.assertEquals((String)("list is " + list), (int)9, (int)list.size());
        OOBTest.assertTrue((boolean)list.contains(2L));
        Util.sleep(2000L);
        System.out.println("[" + Thread.currentThread().getName() + "]: unlocking lock");
        this.lock.unlock();
        Util.sleep(10L);
        list = receiver.getMsgs();
        OOBTest.assertEquals((String)("list is " + list), (int)10, (int)list.size());
        for (long i = 1L; i <= 10L; ++i) {
            OOBTest.assertTrue((boolean)list.contains(i));
        }
    }

    private static void check(int num_expected_msgs, List<Integer> ... lists) {
        for (List<Integer> list : lists) {
            System.out.println("list: " + list);
        }
        for (List<Integer> list : lists) {
            assert (list.size() == num_expected_msgs) : "expected " + num_expected_msgs + " elements, but got " + list.size() + " (list=" + list + ")";
            for (int i = 0; i < num_expected_msgs; ++i) {
                assert (list.contains(i));
            }
        }
    }

    private static void setOOBPoolSize(JChannel channel) {
        TP transport = channel.getProtocolStack().getTransport();
        transport.setOOBMinPoolSize(1);
        transport.setOOBMaxPoolSize(2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        private final List<Integer> msgs = new ArrayList<Integer>(3);

        private MyReceiver() {
        }

        public List<Integer> getMsgs() {
            return this.msgs;
        }

        @Override
        public void receive(Message msg) {
            Integer val = (Integer)msg.getObject();
            this.msgs.add(val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockingReceiver
    extends ReceiverAdapter {
        final Lock lock;
        final List<Long> msgs = new LinkedList<Long>();

        public BlockingReceiver(Lock lock) {
            this.lock = lock;
        }

        public List<Long> getMsgs() {
            return this.msgs;
        }

        @Override
        public void receive(Message msg) {
            if (!msg.isFlagSet((byte)1)) {
                this.lock.lock();
                this.lock.unlock();
            }
            this.msgs.add((Long)msg.getObject());
        }
    }
}

