/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.util.Queue;

public class QueueSpeedTest {
    int num_elements = 1000000;
    static final int NUM = 10;

    public QueueSpeedTest(int num_elements) {
        this.num_elements = num_elements;
    }

    public void start() throws Exception {
        double q1 = 0.0;
        System.out.println("warming up cache");
        this.measureQueue();
        System.out.println("running insertions 10 times (will take average)");
        for (int i = 0; i < 10; ++i) {
            System.out.println("Round #" + (i + 1));
            q1 += (double)this.measureQueue();
        }
        System.out.println("Time to insert and remove " + this.num_elements + " into Queue:           " + (q1 /= 10.0) + " ms");
    }

    long measureQueue() throws Exception {
        Queue q = new Queue();
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.num_elements; ++i) {
            if (i % 2 == 0) {
                q.add(new Integer(i));
                continue;
            }
            q.addAtHead(new Integer(i));
        }
        while (q.size() > 0) {
            q.remove();
        }
        long stop = System.currentTimeMillis();
        return stop - start;
    }

    public static void main(String[] args) {
        int num_elements = 1000000;
        for (int i = 0; i < args.length; ++i) {
            if (!"-num_elements".equals(args[i])) {
                QueueSpeedTest.help();
                return;
            }
            num_elements = Integer.parseInt(args[++i]);
        }
        try {
            new QueueSpeedTest(num_elements).start();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("QueueSpeedTest [-help] [-num_elements <num>]");
    }
}

