/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.TCPMessage;
import com.tandbergtv.workflow.message.TCPPayload;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.log4j.Logger;

public class TCPDispatcher
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(TCPDispatcher.class);
    private Socket socket;
    private BufferedReader reader;
    private PrintWriter writer;

    protected TCPDispatcher() {
    }

    public TCPDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    protected BufferedReader getReader() {
        return this.reader;
    }

    protected void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    protected void initialize() throws DispatcherException {
        logger.debug((Object)"Initializing...");
        this.connect();
        this.openStreams();
    }

    protected void destroy() throws DispatcherException {
        logger.debug((Object)"Destroying...");
        this.closeStreams();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage send(IMessage msg) throws DispatcherException {
        try {
            this.initialize();
            TCPMessage tCPMessage = this.sendMessage(msg);
            return tCPMessage;
        }
        finally {
            this.destroy();
        }
    }

    protected TCPMessage sendMessage(IMessage msg) throws DispatcherException {
        if (msg.getPayload() instanceof TCPPayload) {
            try {
                String payload = msg.getPayload().getContent();
                this.writer.println(payload);
                String responseString = this.reader.readLine();
                TCPPayload responsePayload = new TCPPayload(responseString);
                TCPMessage responseMessage = new TCPMessage(responsePayload);
                return responseMessage;
            }
            catch (Exception ex) {
                throw new DispatcherException("Could not send message", ex);
            }
        }
        throw new DispatcherException("Cannot handle anything other than TCPPayload");
    }

    protected void connect() throws DispatcherException {
        try {
            if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
                TCPDevice tcpDestination = (TCPDevice)this.getDestination();
                this.socket = new Socket(tcpDestination.getIP(), tcpDestination.getPort());
                logger.debug((Object)("New socket created for: " + tcpDestination));
            }
        }
        catch (IOException ioe) {
            throw new DispatcherException("Could not connect to the destination", ioe);
        }
    }

    protected void disconnect() throws DispatcherException {
        try {
            if (this.socket != null) {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
                this.socket = null;
                logger.debug((Object)"Socket disconnected");
            }
        }
        catch (IOException ioe) {
            throw new DispatcherException("Could not disconnect", ioe);
        }
    }

    protected void openStreams() throws DispatcherException {
        try {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            }
            if (this.writer == null) {
                this.writer = new PrintWriter(this.socket.getOutputStream(), true);
            }
            logger.debug((Object)"Opening streams successful");
        }
        catch (IOException ioe) {
            throw new DispatcherException("Could not open streams", ioe);
        }
    }

    protected void closeStreams() throws DispatcherException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            logger.debug((Object)"Closing Streams successful");
        }
        catch (IOException ioe) {
            throw new DispatcherException("Could not close the streams", ioe);
        }
    }
}

