#!/bin/bash

# Create the SFTPUser user with the UID of 65533, Salted Password, Group, Home, Bash
getent passwd sftpuser >/dev/null || useradd -u 65533 -p '$1$8wEpetY/$tjBTGRKIgPBVFNpkAkutQ/' -g nobody -c "SFTPUser" -d /content/uploaded -s /bin/bash sftpuser

#Create /content environment 
mkdir -pv /content/{derived,mapped,unmapped,data,txns_temp,uploaded}

#Create new section for Allow/Deny Access (Keeping it neat for the future)
if grep -q "Allow.*Deny.*Users.*Groups" /etc/ssh/sshd_config
then 
    echo "NO ACTION: Allow/Deny User/Groups section already in sshd_config"
else
    echo "ACTION:    Adding Allow/Deny Users/Groups section to sshd_config"
    echo "" >> /etc/ssh/sshd_config
    echo "# Allow/Deny Users/Groups" >> /etc/ssh/sshd_config
fi

#Add AllowUsers sftpuser under section if if doesn't exist
if grep -q "^AllowUsers.*sftpuser" /etc/ssh/sshd_config
then 
    echo "NO ACTION: AllowUsers sftpuser already in sshd_config"
else
    echo "ACTION:    AllowUsers sftpuser in sshd_config"
    sed -i '/Allow.*Deny.*Users.*Groups/a\AllowUsers sftpuser' /etc/ssh/sshd_config
fi

if grep -q "#Subsystem.*sftp.*/usr/libexec/openssh/sftp-server" /etc/ssh/sshd_config
then
    echo "NO ACTION: Already using internal-sftp over openssh/sftp-server in sshd_config"
else
    # Disable old sftpserver
    echo "ACTION:    Disabling openssh/sftp-server"
    sed -i 's|Subsystem\tsftp\t/usr/libexec/openssh/sftp-server|#Subsystem\tsftp\t/usr/libexec/openssh/sftp-server|g' /etc/ssh/sshd_config
    # Enable new sftpserver
    echo "ACTION:    Enabling internal-sftp"
    echo " "                                        >> /etc/ssh/sshd_config
    echo "Subsystem sftp internal-sftp"             >> /etc/ssh/sshd_config
    #echo "Match Group nobody"                       >> /etc/ssh/sshd_config
    #echo "       X11Forwarding no"                  >> /etc/ssh/sshd_config
    #echo "       AllowTCPForwarding no"             >> /etc/ssh/sshd_config
    #echo "       ForceCommand internal-sftp -u 000" >> /etc/ssh/sshd_config
    #echo " "                                        >> /etc/ssh/sshd_config
    echo "Match User sftpuser"                      >> /etc/ssh/sshd_config
    echo "       X11Forwarding no"                  >> /etc/ssh/sshd_config
    echo "       AllowTCPForwarding no"             >> /etc/ssh/sshd_config
    echo "       ForceCommand internal-sftp -u 000" >> /etc/ssh/sshd_config
    echo " "                                        >> /etc/ssh/sshd_config
fi

#Add Profile data 
if [[ ! -f /content/uploaded/.bash_logout ]]; then
    echo "ACTION:    Copying .bash_logout from root profile"
    cp -n /root/.bash_logout  /content/uploaded/
fi
if [[ ! -f /content/uploaded/.bash_profile ]]; then
    echo "ACTION:    Copying .bash_profile from root profile"
    cp -n /root/.bash_profile  /content/uploaded/
fi
if [[ ! -f /content/uploaded/.bashrc ]]; then
    echo "ACTION:    Copying .bashrc from root profile"
    cp -n /root/.bashrc  /content/uploaded/
fi
    
#Make sftphome and Set the Permissions
if [[ ! -d /content/uploaded ]]; then 
   echo "ACTION:    Creating /content/uploaded and setting default permissions"
   mkdir -p /content/uploaded
   chown -R sftpuser:nobody /content/uploaded > /dev/null 2>&1
   find /content/uploaded  -type d -exec chmod 777 {} \; 
   find /content/uploaded  -type f -exec chmod 666 {} \;
elif [[ -d /content/uploaded ]]; then 
   echo "ACTION:    Updating /content/uploaded with default permissions (may take some time)"
   chown -R sftpuser:nobody /content/uploaded > /dev/null 2>&1
   find /content/uploaded  -type d -exec chmod 777 {} \; 
   find /content/uploaded  -type f -exec chmod 666 {} \;
fi

# Restart sshd service for setting to take effect
echo "Finalizing setup"
service sshd restart
echo "SFTPUser configuration complete."
