/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.Messaging.ExceptionHolder;

public class ExceptionHolderImpl
extends ExceptionHolder
implements Configurable {
    private Logger logger = null;

    public ExceptionHolderImpl(ReplyInputStream replyInputStream) {
        int n = replyInputStream.getStatus().value();
        if (n == 1) {
            this.is_system_exception = false;
        } else if (n == 2) {
            this.is_system_exception = true;
        } else {
            throw new RuntimeException("attempt to create ExceptionHolder for non-exception reply");
        }
        this.byte_order = replyInputStream.littleEndian;
        this.marshaled_exception = replyInputStream.getBody();
    }

    public ExceptionHolderImpl(SystemException systemException) {
        this.is_system_exception = true;
        this.byte_order = false;
        CDROutputStream cDROutputStream = new CDROutputStream();
        SystemExceptionHelper.write(cDROutputStream, systemException);
        this.marshaled_exception = cDROutputStream.getBufferCopy();
    }

    public ExceptionHolderImpl() {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.exc_holder");
    }

    public void raise_exception() throws UserException {
        String string;
        CDRInputStream cDRInputStream;
        block5: {
            cDRInputStream = new CDRInputStream(null, this.marshaled_exception, this.byte_order);
            if (this.is_system_exception) {
                throw SystemExceptionHelper.read(cDRInputStream);
            }
            cDRInputStream.mark(0);
            string = cDRInputStream.read_string();
            try {
                cDRInputStream.reset();
            }
            catch (IOException iOException) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("Unexpected IOException: " + iOException.getMessage());
            }
        }
        UserException userException = null;
        try {
            userException = this.exceptionFromHelper(string, cDRInputStream);
        }
        catch (Exception exception) {
            throw new UnknownUserException();
        }
        throw userException;
    }

    public void raise_exception_with_list(ExceptionList exceptionList) throws UserException {
        throw new NO_IMPLEMENT("raise_exception_with_list not yet implemented");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.marshaled_exception.length; ++i) {
            stringBuffer.append(this.marshaled_exception[i] + "(" + (char)this.marshaled_exception[i] + ")  ");
        }
        return stringBuffer.toString();
    }

    public UserException exceptionFromHelper(String string, InputStream inputStream) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String string2 = RepositoryID.className(string, "Helper", null);
        Class clazz = ObjectUtil.classForName(string2);
        Method method = clazz.getMethod("read", ObjectUtil.classForName("org.omg.CORBA.portable.InputStream"));
        Object object = method.invoke(null, inputStream);
        return (UserException)object;
    }

    public byte[] marshal() {
        byte[] byArray = BufferManager.getInstance().getBuffer(this.marshaled_exception.length + 128);
        CDROutputStream cDROutputStream = new CDROutputStream(byArray);
        cDROutputStream.write_value((Serializable)this, "IDL:omg.org/Messaging/ExceptionHolder:1.0");
        return byArray;
    }
}

