/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.logging.internal;

import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class LogListenerBridge
implements LogListener {
    public void logged(LogEntry entry) {
        Bundle bundle = entry.getBundle();
        int level = entry.getLevel();
        Throwable throwable = entry.getException();
        String loggerName = bundle.getSymbolicName();
        Logger log = Logger.getLogger((String)loggerName);
        String message = entry.getMessage();
        if (level == 4) {
            log.debug((Object)message, throwable);
        } else if (level == 3) {
            String[] splitMessage = message.split("[\\s]");
            if (throwable != null || splitMessage.length != 2 || !splitMessage[0].endsWith("Event")) {
                log.info((Object)message, throwable);
            }
        } else if (level == 2) {
            log.warn((Object)message, throwable);
        } else if (level == 1) {
            log.error((Object)message, throwable);
        }
    }
}

