/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate3;

import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.jboss.as.jpa.hibernate3.HibernateAnnotationScanner;
import org.jboss.as.jpa.hibernate3.HibernateSecondLevelCache;
import org.jboss.as.jpa.hibernate3.JBossAppServerJtaPlatform;
import org.jboss.as.jpa.spi.JtaManager;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class HibernatePersistenceProviderAdaptor
implements PersistenceProviderAdaptor {
    public static final String SCANNER = "hibernate.ejb.resource_scanner";
    private static final String HIBERNATE_ANNOTATION_SCANNER_CLASS = "org.jboss.as.jpa.hibernate3.HibernateAnnotationScanner";

    public void injectJtaManager(JtaManager jtaManager) {
        JBossAppServerJtaPlatform.initJBossAppServerJtaPlatform(jtaManager);
    }

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        this.putPropertyIfAbsent(pu, properties, "hibernate.transaction.manager_lookup_class", JBossAppServerJtaPlatform.class.getName());
        this.putPropertyIfAbsent(pu, properties, "hibernate.id.new_generator_mappings", "true");
        this.addAnnotationScanner(pu);
    }

    private void addAnnotationScanner(PersistenceUnitMetadata pu) {
        try {
            Configuration.class.getClassLoader().loadClass(HIBERNATE_ANNOTATION_SCANNER_CLASS);
            pu.getProperties().put(SCANNER, HIBERNATE_ANNOTATION_SCANNER_CLASS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addProviderDependencies(ServiceRegistry registry, ServiceTarget target, ServiceBuilder<?> builder, PersistenceUnitMetadata pu) {
        if (Boolean.parseBoolean(pu.getProperties().getProperty("hibernate.cache.use_second_level_cache"))) {
            HibernateSecondLevelCache.addSecondLevelCacheDependencies(registry, target, builder, pu);
        }
    }

    private void putPropertyIfAbsent(PersistenceUnitMetadata pu, Map properties, String property, Object value) {
        if (!pu.getProperties().containsKey(property)) {
            properties.put(property, value);
        }
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        if (pu.getProperties().containsKey(SCANNER)) {
            try {
                Class<?> scanner = Configuration.class.getClassLoader().loadClass(HIBERNATE_ANNOTATION_SCANNER_CLASS);
                Method setThreadLocalPersistenceUnitMetadata = scanner.getMethod("setThreadLocalPersistenceUnitMetadata", PersistenceUnitMetadata.class);
                setThreadLocalPersistenceUnitMetadata.invoke(null, pu);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        if (pu.getProperties().containsKey(SCANNER)) {
            try {
                Class<?> scanner = Configuration.class.getClassLoader().loadClass(HIBERNATE_ANNOTATION_SCANNER_CLASS);
                Method clearThreadLocalPersistenceUnitMetadata = scanner.getMethod("clearThreadLocalPersistenceUnitMetadata", new Class[0]);
                clearThreadLocalPersistenceUnitMetadata.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ManagementAdaptor getManagementAdaptor() {
        return null;
    }

    public boolean doesScopedPersistenceUnitNameIdentifyCacheRegionName(PersistenceUnitMetadata pu) {
        return true;
    }

    public void cleanup(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.cleanup(pu);
    }
}

