/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import org.jboss.logging.Logger;
import org.jboss.xb.binding.resolver.MultiClassSchemaResolver;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaResolverFactory;

public class SingletonSchemaResolverFactory
implements SchemaResolverFactory {
    private static final Logger log = Logger.getLogger(SingletonSchemaResolverFactory.class);
    private static final SingletonSchemaResolverFactory singleton = new SingletonSchemaResolverFactory();
    private final MutableSchemaResolver resolver = new MultiClassSchemaResolver();

    public static SingletonSchemaResolverFactory getInstance() {
        return singleton;
    }

    private SingletonSchemaResolverFactory() {
        this.addSchema("urn:jboss:spring-beans:2.0", "org.jboss.spring.deployment.xml.SpringSchemaInitializer", Boolean.FALSE);
        this.addSchema("urn:jboss:osgi-beans:1.0", "org.jboss.osgi.deployment.xml.OSGiSchemaInitializer", Boolean.FALSE);
        this.addSchema("urn:jboss:seam-components:1.0", "org.jboss.seam.ioc.microcontainer.xml.SeamSchemaInitializer", Boolean.FALSE);
        this.addJaxbSchema("urn:jboss:aop-beans:1.0", "org.jboss.aop.microcontainer.beans.metadata.AOPDeployment");
        this.addJaxbSchema("urn:jboss:bean-deployer", "org.jboss.kernel.plugins.deployment.AbstractKernelDeployment10");
        this.addJaxbSchema("urn:jboss:bean-deployer:2.0", "org.jboss.kernel.plugins.deployment.AbstractKernelDeployment");
        this.addJaxbSchema("urn:jboss:javabean:1.0", "org.jboss.javabean.plugins.jaxb.JavaBean10");
        this.addJaxbSchema("urn:jboss:javabean:2.0", "org.jboss.javabean.plugins.jaxb.JavaBean20");
        this.addJaxbSchema("urn:jboss:policy:1.0", "org.jboss.beans.metadata.plugins.policy.AbstractPolicyMetaData");
        this.addJaxbSchema("urn:jboss:classloading:1.0", "org.jboss.classloading.spi.metadata.ClassLoadingMetaData10");
        this.addJaxbSchema("urn:jboss:classloader:1.0", "org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory10");
        this.addJaxbSchema("urn:jboss:deployers:2.0", "org.jboss.deployers.vfs.plugins.xb.SchemaResolverDeployerMetaData");
    }

    @Override
    public MutableSchemaResolver getSchemaBindingResolver() {
        return this.resolver;
    }

    protected boolean addSchema(String namespace, String initializer) {
        try {
            this.resolver.mapSchemaInitializer(namespace, initializer);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Mapped initializer '" + namespace + "' to '" + initializer + "'"));
            }
            return true;
        }
        catch (Exception ignored) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Ignored: ", (Throwable)ignored);
            }
            return false;
        }
    }

    protected boolean addSchema(String namespace, String initializer, Boolean parseAnnotations) {
        if (!this.addSchema(namespace, initializer)) {
            return false;
        }
        this.setParseAnnotations(namespace, parseAnnotations);
        return true;
    }

    protected boolean addSchema(String namespace, String initializer, String location) {
        if (!this.addSchema(namespace, initializer)) {
            return false;
        }
        try {
            this.resolver.mapSchemaLocation(namespace, location);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Mapped location '" + namespace + "' to '" + location + "'"));
            }
            return true;
        }
        catch (Exception ignored) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Ignored: ", (Throwable)ignored);
            }
            return false;
        }
    }

    protected boolean addSchema(String namespace, String initializer, String location, Boolean parseAnnotations) {
        if (!this.addSchema(namespace, initializer, location)) {
            return false;
        }
        this.setParseAnnotations(namespace, parseAnnotations);
        return true;
    }

    protected void setParseAnnotations(String namespace, Boolean parseAnnotations) {
        if (parseAnnotations != null) {
            this.resolver.setParseXSDAnnotations(namespace, parseAnnotations);
        } else {
            this.resolver.unsetParseXSDAnnotations(namespace);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Parse annotations '" + namespace + "' set to '" + parseAnnotations + "'"));
        }
    }

    public boolean addJaxbSchema(String namespace, String reference) {
        try {
            this.resolver.mapURIToClass(namespace, reference);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Mapped '" + namespace + "' to '" + reference + "'"));
            }
            return true;
        }
        catch (Exception ignored) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Ignored: ", (Throwable)ignored);
            }
            return false;
        }
    }
}

