/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import javax.management.MBeanOperationInfo;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.api.core.management.BroadcastGroupControl;
import org.hornetq.core.management.impl.AbstractControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.utils.json.JSONArray;

public class BroadcastGroupControlImpl
extends AbstractControl
implements BroadcastGroupControl {
    private final BroadcastGroup broadcastGroup;
    private final BroadcastGroupConfiguration configuration;

    public BroadcastGroupControlImpl(BroadcastGroup broadcastGroup, StorageManager storageManager, BroadcastGroupConfiguration configuration) throws Exception {
        super(BroadcastGroupControl.class, storageManager);
        this.broadcastGroup = broadcastGroup;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBroadcastPeriod() {
        this.clearIO();
        try {
            long l = this.configuration.getBroadcastPeriod();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getConnectorPairs() {
        this.clearIO();
        try {
            Object[] ret = new Object[this.configuration.getConnectorInfos().size()];
            int i = 0;
            for (String connector : this.configuration.getConnectorInfos()) {
                ret[i++] = connector;
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectorPairsAsJSON() throws Exception {
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            for (String connector : this.configuration.getConnectorInfos()) {
                array.put((Object)connector);
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getGroupAddress() throws Exception {
        this.clearIO();
        try {
            if (this.configuration.getEndpointFactoryConfiguration() instanceof UDPBroadcastGroupConfiguration) {
                String string = ((UDPBroadcastGroupConfiguration)this.configuration.getEndpointFactoryConfiguration()).getGroupAddress();
                return string;
            }
            throw new Exception("Invalid request because this is not a UDP Broadcast configuration.");
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getGroupPort() throws Exception {
        this.clearIO();
        try {
            if (this.configuration.getEndpointFactoryConfiguration() instanceof UDPBroadcastGroupConfiguration) {
                int n = ((UDPBroadcastGroupConfiguration)this.configuration.getEndpointFactoryConfiguration()).getGroupPort();
                return n;
            }
            throw new Exception("Invalid request because this is not a UDP Broadcast configuration.");
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getLocalBindPort() throws Exception {
        this.clearIO();
        try {
            if (this.configuration.getEndpointFactoryConfiguration() instanceof UDPBroadcastGroupConfiguration) {
                int n = ((UDPBroadcastGroupConfiguration)this.configuration.getEndpointFactoryConfiguration()).getLocalBindPort();
                return n;
            }
            throw new Exception("Invalid request because this is not a UDP Broadcast configuration.");
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.broadcastGroup.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.clearIO();
        try {
            this.broadcastGroup.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        this.clearIO();
        try {
            this.broadcastGroup.stop();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(BroadcastGroupControl.class);
    }
}

