/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateXidImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TransactionImporterImple
implements TransactionImporter {
    private static ConcurrentHashMap<SubordinateXidImple, TransactionImple> _transactions = new ConcurrentHashMap();

    @Override
    public SubordinateTransaction importTransaction(Xid xid) throws XAException {
        return this.importTransaction(xid, 0);
    }

    @Override
    public SubordinateTransaction importTransaction(Xid xid, int timeout) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple imported = (TransactionImple)this.getImportedTransaction(xid);
        if (imported == null) {
            imported = new TransactionImple(timeout, xid);
            _transactions.put(new SubordinateXidImple(imported.baseXid()), imported);
        }
        return imported;
    }

    @Override
    public TransactionImple recoverTransaction(Uid actId) throws XAException {
        if (actId == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple recovered = new TransactionImple(actId);
        if (recovered.baseXid() == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple tx2 = _transactions.get(recovered.baseXid());
        if (tx2 == null) {
            Xid baseXid = recovered.baseXid();
            _transactions.put(new SubordinateXidImple(baseXid), recovered);
            recovered.recordTransaction();
            return recovered;
        }
        return tx2;
    }

    @Override
    public SubordinateTransaction getImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        SubordinateTransaction tx2 = _transactions.get(new SubordinateXidImple(xid));
        if (tx2 == null) {
            return null;
        }
        try {
            if (tx2.getStatus() == 4) {
                throw new XAException(100);
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
            throw new XAException(100);
        }
        if (!tx2.activated()) {
            tx2.recover();
            return tx2;
        }
        return tx2;
    }

    @Override
    public void removeImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        _transactions.remove(new SubordinateXidImple(xid));
    }

    public Set<Xid> getInflightXids(String parentNodeName) {
        Iterator<TransactionImple> iterator = _transactions.values().iterator();
        HashSet<Xid> toReturn = new HashSet<Xid>();
        while (iterator.hasNext()) {
            TransactionImple next = iterator.next();
            if (!next.getParentNodeName().equals(parentNodeName)) continue;
            toReturn.add(next.baseXid());
        }
        return toReturn;
    }
}

