/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.RootOA;
import com.arjuna.orbportability.Services;

public class ORBManager {
    private static ORB _theOrb = null;
    private static OA _thePoa = null;
    private static final String ORB_NAME = "TransactionORB";

    public static final ORB getORB() {
        if (ORBManager.isInitialised()) {
            return ORBManager.getTheORB();
        }
        jtsLogger.i18NLogger.fatal_ORBManager();
        throw new FatalError();
    }

    private static final ORB getTheORB() {
        if (_theOrb == null) {
            _theOrb = ORB.getInstance(ORB_NAME);
        }
        return _theOrb;
    }

    public static final boolean setORB(ORB theOrb) {
        if (_theOrb == null) {
            _theOrb = theOrb;
            return true;
        }
        return false;
    }

    public static final OA getPOA() {
        if (ORBManager.isInitialised()) {
            return ORBManager.getThePOA();
        }
        jtsLogger.i18NLogger.fatal_ORBManager();
        throw new FatalError();
    }

    private static final OA getThePOA() {
        if (_thePoa == null) {
            _thePoa = RootOA.getRootOA(_theOrb);
        }
        return _thePoa;
    }

    public static final boolean setPOA(OA thePoa) {
        if (_thePoa == null) {
            _thePoa = thePoa;
            return true;
        }
        return false;
    }

    public static final Services getServices() {
        return new Services(_theOrb);
    }

    public static final boolean isInitialised() {
        return _theOrb != null || _thePoa != null;
    }

    public static void reset() {
        _theOrb = null;
        _thePoa = null;
    }
}

