/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.net.InetSocketAddress;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ModClusterGetProxyInfo
implements OperationStepHandler {
    static final ModClusterGetProxyInfo INSTANCE = new ModClusterGetProxyInfo();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ModClusterService.NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    ModCluster modcluster = (ModCluster)controller.getValue();
                    Map<InetSocketAddress, String> map = modcluster.getProxyInfo();
                    ModClusterLogger.ROOT_LOGGER.debugf("Mod_cluster ProxyInfo %s", map);
                    if (!map.isEmpty()) {
                        ModelNode result = new ModelNode();
                        Object[] addr = map.keySet().toArray();
                        for (int i = 0; i < addr.length; ++i) {
                            InetSocketAddress address = (InetSocketAddress)addr[i];
                            result.add(address.getHostName() + ":" + address.getPort());
                            result.add(map.get(addr[i]));
                        }
                        context.getResult().set(result);
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

