/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.net.URL;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.naming.NamingMessages;
import org.jboss.dmr.ModelNode;

class BindingTypeRejectChecker
extends RejectAttributeChecker.DefaultRejectAttributeChecker
implements RejectAttributeChecker {
    private String rejectMessage = null;

    BindingTypeRejectChecker() {
    }

    public boolean rejectOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
        return this.rejectCheck(attributeValue, operation);
    }

    private boolean rejectCheck(ModelNode attributeValue, ModelNode model) {
        String type = attributeValue.asString();
        if (type.equals("simple") && model.hasDefined("type")) {
            if (URL.class.getName().equals(model.get("type").asString())) {
                this.rejectMessage = NamingMessages.MESSAGES.failedToTransformSimpleURLNameBindingAddOperation("1.1.0");
                return true;
            }
        } else if (type.equals("object-factory") && model.hasDefined("environment")) {
            this.rejectMessage = NamingMessages.MESSAGES.failedToTransformObjectFactoryWithEnvironmentNameBindingAddOperation("1.1.0");
            return true;
        }
        return false;
    }

    protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        return false;
    }

    public boolean rejectResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        ModelNode model = context.readResource(address).getModel();
        return this.rejectCheck(attributeValue, model);
    }

    public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
        return this.rejectMessage;
    }
}

