/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.List;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingLogger;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.management.JndiViewExtensionRegistry;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class NamingSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final CompositeName EMPTY_NAME = new CompositeName();
    static final NamingSubsystemAdd INSTANCE = new NamingSubsystemAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        NamingLogger.ROOT_LOGGER.activatingSubsystem();
        NamingContext.initializeNamingManager();
        ServiceContainer serviceContainer = CurrentServiceContainer.getServiceContainer();
        ServiceTarget target = context.getServiceTarget();
        WritableServiceBasedNamingStore namingStore = new WritableServiceBasedNamingStore((ServiceRegistry)serviceContainer, ContextNames.JAVA_CONTEXT_SERVICE_NAME, target);
        newControllers.add(target.addService(NamingService.SERVICE_NAME, (Service)new NamingService(namingStore)).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME}).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        final WritableServiceBasedNamingStore globalNamingStore = new WritableServiceBasedNamingStore((ServiceRegistry)serviceContainer, ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, target);
        newControllers.add(target.addService(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, (Service)new NamingStoreService(globalNamingStore)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        final WritableServiceBasedNamingStore jbossNamingStore = new WritableServiceBasedNamingStore((ServiceRegistry)serviceContainer, ContextNames.JBOSS_CONTEXT_SERVICE_NAME, target);
        newControllers.add(target.addService(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, (Service)new NamingStoreService(jbossNamingStore)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        final WritableServiceBasedNamingStore remoteExposedNamingStore = new WritableServiceBasedNamingStore((ServiceRegistry)serviceContainer, ContextNames.EXPORTED_CONTEXT_SERVICE_NAME, target);
        newControllers.add(target.addService(ContextNames.EXPORTED_CONTEXT_SERVICE_NAME, (Service)new NamingStoreService(remoteExposedNamingStore)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        NamespaceContextSelector.setDefault(new NamespaceContextSelector(){

            @Override
            public Context getContext(String identifier) {
                ServiceBasedNamingStore namingStore = identifier.equals("global") ? globalNamingStore : (identifier.equals("jboss") ? jbossNamingStore : (identifier.equals("jboss/exported") ? remoteExposedNamingStore : null));
                if (namingStore != null) {
                    try {
                        return (Context)namingStore.lookup(EMPTY_NAME);
                    }
                    catch (NamingException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return null;
            }
        });
        newControllers.add(target.addService(JndiViewExtensionRegistry.SERVICE_NAME, (Service)new JndiViewExtensionRegistry()).install());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("naming", Phase.INSTALL, 7169, (DeploymentUnitProcessor)new JndiNamingDependencyProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

