/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.accessor.Accessor;
import org.jboss.ws.metadata.accessor.AccessorFactory;
import org.jboss.ws.metadata.accessor.ReflectiveFieldAccessor;
import org.jboss.ws.metadata.umdm.WrappedParameter;

final class ReflectiveFieldAccessorFactory
implements AccessorFactory {
    private final Class<?> clazz;

    ReflectiveFieldAccessorFactory(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Accessor create(WrappedParameter parameter) {
        String fieldName = parameter.getVariable();
        try {
            Field field;
            try {
                field = this.clazz.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                field = this.clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            if (Modifier.isStatic(field.getModifiers())) {
                throw NativeMessages.MESSAGES.fieldCannotBeStatic(fieldName);
            }
            return new ReflectiveFieldAccessor(field);
        }
        catch (Throwable t) {
            throw new WSException(t);
        }
    }
}

