/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class InVMTransport
extends Transport {
    private String nodeName = null;
    private String managerName = null;
    UDDIInquiryPortType inquiryService = null;
    UDDISecurityPortType securityService = null;
    UDDIPublicationPortType publishService = null;
    UDDISubscriptionPortType subscriptionService = null;
    UDDISubscriptionListenerPortType subscriptionListenerService = null;
    UDDICustodyTransferPortType custodyTransferService = null;
    JUDDIApiPortType publisherService = null;

    public InVMTransport() {
        this.nodeName = "default";
    }

    public InVMTransport(String nodeName) {
        this.nodeName = nodeName;
    }

    public InVMTransport(String managerName, String nodeName) {
        this.nodeName = nodeName;
        this.managerName = managerName;
    }

    @Override
    public UDDIInquiryPortType getUDDIInquiryService(String endpointURL) throws TransportException {
        if (this.inquiryService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getInquiryUrl();
                }
                Class<?> c = Class.forName(endpointURL);
                this.inquiryService = (UDDIInquiryPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.inquiryService;
    }

    @Override
    public UDDISecurityPortType getUDDISecurityService(String endpointURL) throws TransportException {
        if (this.securityService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSecurityUrl();
                }
                Class<?> c = Class.forName(endpointURL);
                this.securityService = (UDDISecurityPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.securityService;
    }

    @Override
    public UDDIPublicationPortType getUDDIPublishService(String endpointURL) throws TransportException {
        if (this.publishService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getPublishUrl();
                }
                Class<?> c = Class.forName(endpointURL);
                this.publishService = (UDDIPublicationPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publishService;
    }

    @Override
    public UDDISubscriptionPortType getUDDISubscriptionService(String endpointURL) throws TransportException {
        if (this.subscriptionService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSubscriptionUrl();
                }
                Class<?> c = Class.forName(endpointURL);
                this.subscriptionService = (UDDISubscriptionPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionService;
    }

    @Override
    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService(String endpointURL) throws TransportException {
        if (this.subscriptionListenerService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSubscriptionListenerUrl();
                }
                Class<?> c = Class.forName(endpointURL);
                this.subscriptionListenerService = (UDDISubscriptionListenerPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionListenerService;
    }

    @Override
    public UDDICustodyTransferPortType getUDDICustodyTransferService(String endpointURL) throws TransportException {
        if (this.custodyTransferService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getCustodyTransferUrl();
                }
                Class<?> c = Class.forName(endpointURL);
                this.custodyTransferService = (UDDICustodyTransferPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.custodyTransferService;
    }

    @Override
    public JUDDIApiPortType getJUDDIApiService(String endpointURL) throws TransportException {
        if (this.publisherService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getJuddiApiUrl();
                }
                Class<?> c = Class.forName(endpointURL);
                this.publisherService = (JUDDIApiPortType)c.newInstance();
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publisherService;
    }
}

