/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WrapDynaBean;

public class WrapDynaClass
implements DynaClass {
    private String beanClassName = null;
    private Reference beanClassRef = null;
    protected Class beanClass = null;
    protected PropertyDescriptor[] descriptors = null;
    protected HashMap descriptorsMap = new HashMap();
    protected DynaProperty[] properties = null;
    protected HashMap propertiesMap = new HashMap();
    private static final ContextClassLoaderLocal CLASSLOADER_CACHE = new ContextClassLoaderLocal(){

        @Override
        protected Object initialValue() {
            return new WeakHashMap();
        }
    };
    protected static HashMap dynaClasses = new HashMap(){

        @Override
        public void clear() {
            WrapDynaClass.getDynaClassesMap().clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return WrapDynaClass.getDynaClassesMap().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return WrapDynaClass.getDynaClassesMap().containsValue(value);
        }

        @Override
        public Set entrySet() {
            return WrapDynaClass.getDynaClassesMap().entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)WrapDynaClass.getDynaClassesMap()).equals(o);
        }

        @Override
        public Object get(Object key) {
            return WrapDynaClass.getDynaClassesMap().get(key);
        }

        @Override
        public int hashCode() {
            return ((Object)WrapDynaClass.getDynaClassesMap()).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return WrapDynaClass.getDynaClassesMap().isEmpty();
        }

        @Override
        public Set keySet() {
            return WrapDynaClass.getDynaClassesMap().keySet();
        }

        @Override
        public Object put(Object key, Object value) {
            return WrapDynaClass.getDynaClassesMap().put(key, value);
        }

        @Override
        public void putAll(Map m) {
            WrapDynaClass.getDynaClassesMap().putAll(m);
        }

        @Override
        public Object remove(Object key) {
            return WrapDynaClass.getDynaClassesMap().remove(key);
        }

        @Override
        public int size() {
            return WrapDynaClass.getDynaClassesMap().size();
        }

        @Override
        public Collection values() {
            return WrapDynaClass.getDynaClassesMap().values();
        }
    };

    private WrapDynaClass(Class beanClass) {
        this.beanClassRef = new SoftReference<Class>(beanClass);
        this.beanClassName = beanClass.getName();
        this.introspect();
    }

    private static Map getDynaClassesMap() {
        return (Map)CLASSLOADER_CACHE.get();
    }

    protected Class getBeanClass() {
        return (Class)this.beanClassRef.get();
    }

    @Override
    public String getName() {
        return this.beanClassName;
    }

    @Override
    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(name);
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    @Override
    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new WrapDynaBean(this.getBeanClass().newInstance());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return (PropertyDescriptor)this.descriptorsMap.get(name);
    }

    public static void clear() {
        WrapDynaClass.getDynaClassesMap().clear();
    }

    public static WrapDynaClass createDynaClass(Class beanClass) {
        WrapDynaClass dynaClass = (WrapDynaClass)WrapDynaClass.getDynaClassesMap().get(beanClass);
        if (dynaClass == null) {
            dynaClass = new WrapDynaClass(beanClass);
            WrapDynaClass.getDynaClassesMap().put(beanClass, dynaClass);
        }
        return dynaClass;
    }

    protected void introspect() {
        HashMap mappeds;
        Class beanClass = this.getBeanClass();
        PropertyDescriptor[] regulars = PropertyUtils.getPropertyDescriptors(beanClass);
        if (regulars == null) {
            regulars = new PropertyDescriptor[]{};
        }
        if ((mappeds = PropertyUtils.getMappedPropertyDescriptors(beanClass)) == null) {
            mappeds = new HashMap();
        }
        this.properties = new DynaProperty[regulars.length + mappeds.size()];
        for (int i = 0; i < regulars.length; ++i) {
            this.descriptorsMap.put(regulars[i].getName(), regulars[i]);
            this.properties[i] = new DynaProperty(regulars[i].getName(), regulars[i].getPropertyType());
            this.propertiesMap.put(this.properties[i].getName(), this.properties[i]);
        }
        int j = regulars.length;
        for (String name : mappeds.keySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)mappeds.get(name);
            this.properties[j] = new DynaProperty(descriptor.getName(), Map.class);
            this.propertiesMap.put(this.properties[j].getName(), this.properties[j]);
            ++j;
        }
    }
}

