/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.plugins.TransactionManagerLocator;

class DbUtil {
    DbUtil() {
    }

    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm, boolean suspendResume) throws LoginException {
        LoginException le;
        Connection conn = null;
        HashMap<String, Group> setsMap = new HashMap<String, Group>();
        Statement ps = null;
        ResultSet rs = null;
        TransactionManager tm = null;
        if (suspendResume) {
            TransactionManagerLocator tml = new TransactionManagerLocator();
            try {
                tm = tml.getTM("java:/TransactionManager");
            }
            catch (NamingException e1) {
                throw new RuntimeException(e1);
            }
            if (tm == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullTransactionManager();
            }
        }
        Transaction tx = null;
        if (suspendResume) {
            try {
                tx = tm.suspend();
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dsJndiName);
            conn = ds.getConnection();
            PicketBoxLogger.LOGGER.traceExecuteQuery(rolesQuery, username);
            ps = conn.prepareStatement(rolesQuery);
            try {
                ps.setString(1, username);
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                // empty catch block
            }
            rs = ps.executeQuery();
            if (!rs.next()) {
                Group[] roleSets;
                if (aslm.getUnauthenticatedIdentity() == null) {
                    throw PicketBoxMessages.MESSAGES.noMatchingUsernameFoundInRoles();
                }
                Group[] groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                return groupArray;
            }
            do {
                Group group;
                String name = rs.getString(1);
                String groupName = rs.getString(2);
                if (groupName == null || groupName.length() == 0) {
                    groupName = "Roles";
                }
                if ((group = (Group)setsMap.get(groupName)) == null) {
                    group = new SimpleGroup(groupName);
                    setsMap.put(groupName, group);
                }
                try {
                    Principal p = aslm.createIdentity(name);
                    group.addMember(p);
                }
                catch (Exception e) {
                    PicketBoxLogger.LOGGER.debugFailureToCreatePrincipal(name, e);
                }
            } while (rs.next());
        }
        catch (NamingException ex) {
            le = new LoginException(PicketBoxMessages.MESSAGES.failedToLookupDataSourceMessage(dsJndiName));
            le.initCause(ex);
            throw le;
        }
        catch (SQLException ex) {
            le = new LoginException(PicketBoxMessages.MESSAGES.failedToProcessQueryMessage());
            le.initCause(ex);
            throw le;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
            if (suspendResume) {
                try {
                    tm.resume(tx);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }
}

