/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.config;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.config.MetadataProviderType;
import org.picketlink.identity.federation.core.config.ProviderType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.handler.config.Handler;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.parsers.AbstractParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;

public class SAMLConfigParser
extends AbstractParser {
    public static final String BINDING_TYPE = "BindingType";
    public static final String ERROR_PAGE = "ErrorPage";
    public static final String LOGOUT_PAGE = "LogOutPage";
    public static final String IDP = "PicketLinkIDP";
    public static final String SP = "PicketLinkSP";
    public static final String IDENTITY_URL = "IdentityURL";
    public static final String SERVICE_URL = "ServiceURL";
    public static final String IDP_METADATA_FILE = "IDPMetadataFile";
    public static final String IDP_USES_POST_BINDING = "IDPUsesPostBinding";
    public static final String TRUST = "Trust";
    public static final String DOMAINS = "Domains";
    public static final String KEY_PROVIDER = "KeyProvider";
    public static final String META_PROVIDER = "MetaDataProvider";
    public static final String CLASS_NAME = "ClassName";
    public static final String CLASS = "class";
    public static final String AUTH = "Auth";
    public static final String KEY = "Key";
    public static final String VALUE = "Value";
    public static final String VALIDATING_ALIAS = "ValidatingAlias";
    public static final String ROLE_GENERATOR = "RoleGenerator";
    public static final String ENCRYPT = "Encrypt";
    public static final String ATTRIBUTE_MANAGER = "AttributeManager";
    public static final String CANONICALIZATION_METHOD = "CanonicalizationMethod";
    public static final String HANDLERS = "Handlers";
    public static final String HANDLERS_CHAIN_CLASS = "ChainClass";
    public static final String HANDLER = "Handler";
    public static final String OPTION = "Option";
    public static final String RELAY_STATE = "RelayState";
    public static final String SERVER_ENVIRONMENT = "ServerEnvironment";
    public static final String SUPPORTS_SIGNATURES = "SupportsSignatures";
    public static final String IDENTITY_PARTICIPANT_STACK = "IdentityParticipantStack";
    public static final String STRICT_POST_BINDING = "StrictPostBinding";

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        if (StaxParserUtil.getStartElementName(startElement).equals(IDP)) {
            return this.parseIDPConfiguration(xmlEventReader);
        }
        if (StaxParserUtil.getStartElementName(startElement).equals(SP)) {
            return this.parseSPConfiguration(xmlEventReader);
        }
        return this.parseHandlers(xmlEventReader);
    }

    @Override
    public boolean supports(QName qname) {
        return false;
    }

    protected Handlers parseHandlers(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        Handlers handlers = new Handlers();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, HANDLERS);
        QName attributeQName = new QName("", HANDLERS_CHAIN_CLASS);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            handlers.setHandlerChainClass(StaxParserUtil.getAttributeValue(attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (endElementName.equals(HANDLERS)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (!elementName.equals(HANDLER)) continue;
            Handler handler = this.parseHandler(xmlEventReader, startElement);
            handlers.add(handler);
        }
        return handlers;
    }

    protected IDPType parseIDPConfiguration(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        IDPType idp = new IDPType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, IDP);
        QName attributeQName = new QName("", ROLE_GENERATOR);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            idp.setRoleGenerator(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", ENCRYPT))) != null) {
            idp.setEncrypt(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(attribute)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", CANONICALIZATION_METHOD))) != null) {
            idp.setCanonicalizationMethod(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", ATTRIBUTE_MANAGER))) != null) {
            idp.setAttributeManager(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", STRICT_POST_BINDING))) != null) {
            idp.setStrictPostBinding(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(attribute)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", SUPPORTS_SIGNATURES))) != null) {
            idp.setSupportsSignature(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(attribute)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", IDENTITY_PARTICIPANT_STACK))) != null) {
            idp.setIdentityParticipantStack(StaxParserUtil.getAttributeValue(attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (endElementName.equals(IDP)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (elementName.equals(IDENTITY_URL)) {
                idp.setIdentityURL(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (elementName.equals(TRUST)) {
                TrustType trustType = new TrustType();
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(startElement, DOMAINS);
                trustType.setDomains(StaxParserUtil.getElementText(xmlEventReader));
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, TRUST);
                idp.setTrust(trustType);
                continue;
            }
            if (elementName.equals(KEY_PROVIDER)) {
                KeyProviderType keyProviderType = this.parseKeyProvider(xmlEventReader, startElement);
                idp.setKeyProvider(keyProviderType);
                continue;
            }
            if (!elementName.equals(META_PROVIDER)) continue;
            MetadataProviderType mdProviderType = this.parseMDProvider(xmlEventReader, startElement);
            idp.setMetaDataProvider(mdProviderType);
        }
        return idp;
    }

    protected ProviderType parseSPConfiguration(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        SPType sp = new SPType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, SP);
        QName attributeQName = new QName("", CANONICALIZATION_METHOD);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            sp.setCanonicalizationMethod(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", SERVER_ENVIRONMENT))) != null) {
            sp.setServerEnvironment(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", BINDING_TYPE))) != null) {
            sp.setBindingType(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", RELAY_STATE))) != null) {
            sp.setRelayState(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", ERROR_PAGE))) != null) {
            sp.setErrorPage(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", LOGOUT_PAGE))) != null) {
            sp.setLogOutPage(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", IDP_USES_POST_BINDING))) != null) {
            sp.setIdpUsesPostBinding(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(attribute)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", SUPPORTS_SIGNATURES))) != null) {
            sp.setSupportsSignature(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(attribute)));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (endElementName.equals(SP)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (elementName.equals(IDENTITY_URL)) {
                sp.setIdentityURL(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (elementName.equals(SERVICE_URL)) {
                sp.setServiceURL(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (elementName.equals(IDP_METADATA_FILE)) {
                sp.setIdpMetadataFile(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (elementName.equals(TRUST)) {
                TrustType trustType = new TrustType();
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(startElement, DOMAINS);
                trustType.setDomains(StaxParserUtil.getElementText(xmlEventReader));
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, TRUST);
                sp.setTrust(trustType);
                continue;
            }
            if (elementName.equals(KEY_PROVIDER)) {
                KeyProviderType keyProviderType = this.parseKeyProvider(xmlEventReader, startElement);
                sp.setKeyProvider(keyProviderType);
                continue;
            }
            if (!elementName.equals(META_PROVIDER)) continue;
            MetadataProviderType mdProviderType = this.parseMDProvider(xmlEventReader, startElement);
            sp.setMetaDataProvider(mdProviderType);
        }
        return sp;
    }

    protected KeyProviderType parseKeyProvider(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent = null;
        KeyProviderType keyProviderType = new KeyProviderType();
        QName attributeQName = new QName("", CLASS_NAME);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            keyProviderType.setClassName(StaxParserUtil.getAttributeValue(attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            KeyValueType auth;
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (!endElementName.equals(KEY_PROVIDER)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            String startElementName = StaxParserUtil.getStartElementName(startElement);
            if (startElementName.equals(AUTH)) {
                auth = new AuthPropertyType();
                this.populateKeyValueType(auth, startElement);
                keyProviderType.add((AuthPropertyType)auth);
                continue;
            }
            if (!startElementName.equals(VALIDATING_ALIAS)) continue;
            auth = new KeyValueType();
            this.populateKeyValueType(auth, startElement);
            keyProviderType.add(auth);
        }
        return keyProviderType;
    }

    protected Handler parseHandler(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent = null;
        Handler handlerType = new Handler();
        QName attributeQName = new QName("", CLASS);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            handlerType.setClazz(StaxParserUtil.getAttributeValue(attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (!endElementName.equals(HANDLER)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            String startElementName = StaxParserUtil.getStartElementName(startElement);
            if (!startElementName.equals(OPTION)) continue;
            KeyValueType auth = new KeyValueType();
            this.populateKeyValueType(auth, startElement);
            handlerType.add(auth);
        }
        return handlerType;
    }

    protected MetadataProviderType parseMDProvider(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent = null;
        MetadataProviderType metaProviderType = new MetadataProviderType();
        QName attributeQName = new QName("", CLASS_NAME);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            metaProviderType.setClassName(StaxParserUtil.getAttributeValue(attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (!endElementName.equals(META_PROVIDER)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            String startElementName = StaxParserUtil.getStartElementName(startElement);
            if (!startElementName.equals(OPTION)) continue;
            KeyValueType auth = new KeyValueType();
            this.populateKeyValueType(auth, startElement);
            metaProviderType.add(auth);
        }
        return metaProviderType;
    }

    protected void populateKeyValueType(KeyValueType kvt, StartElement startElement) {
        QName attributeQName = new QName("", KEY);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            kvt.setKey(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", OPTION))) != null) {
            kvt.setKey(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", VALUE))) != null) {
            kvt.setValue(StaxParserUtil.getAttributeValue(attribute));
        }
    }
}

