/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.config.Configuration;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.configuration.cache.AbstractLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ClusterCacheLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.LegacyLoaderConfiguration;
import org.infinispan.configuration.cache.LegacyLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfiguration;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LockSupportStoreConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.loaders.AbstractCacheLoaderConfig;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.cluster.ClusterCacheLoaderConfig;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.Util;

public class LegacyConfigurationAdaptor {
    private LegacyConfigurationAdaptor() {
    }

    public static org.infinispan.config.Configuration adapt(Configuration config) {
        if (config == null) {
            return null;
        }
        FluentConfiguration legacy = new org.infinispan.config.Configuration().fluent();
        legacy.clustering().mode(Configuration.CacheMode.valueOf(config.clustering().cacheMode().name()));
        if (!config.clustering().cacheMode().isSynchronous()) {
            legacy.clustering().async().asyncMarshalling(config.clustering().async().asyncMarshalling()).replQueueInterval(config.clustering().async().replQueueInterval()).replQueueMaxElements(config.clustering().async().replQueueMaxElements()).useReplQueue(config.clustering().async().useReplQueue());
            ReplicationQueue replQueue = config.clustering().async().replQueue();
            if (replQueue != null) {
                legacy.clustering().async().replQueueClass(replQueue.getClass());
            }
        }
        if (config.clustering().hash().hash() != null) {
            legacy.clustering().hash().hashFunctionClass(config.clustering().hash().hash().getClass());
        }
        legacy.clustering().hash().numOwners(config.clustering().hash().numOwners()).groups().enabled(config.clustering().hash().groups().enabled()).groupers(config.clustering().hash().groups().groupers());
        if (config.clustering().cacheMode().isDistributed()) {
            legacy.clustering().hash().rehashEnabled(config.clustering().stateTransfer().fetchInMemoryState()).rehashRpcTimeout(config.clustering().stateTransfer().timeout()).rehashWait(config.clustering().stateTransfer().timeout());
        } else if (config.clustering().cacheMode().isClustered()) {
            legacy.clustering().stateRetrieval().fetchInMemoryState(config.clustering().stateTransfer().fetchInMemoryState()).timeout(config.clustering().stateTransfer().timeout());
        }
        if (config.clustering().l1().enabled()) {
            legacy.clustering().l1().invalidationThreshold(config.clustering().l1().invalidationThreshold()).lifespan(config.clustering().l1().lifespan()).onRehash(config.clustering().l1().onRehash()).cleanupTaskFrequency(config.clustering().l1().cleanupTaskFrequency());
        } else {
            legacy.clustering().l1().disable().onRehash(config.clustering().l1().onRehash());
        }
        legacy.clustering().stateRetrieval().chunkSize(config.clustering().stateTransfer().chunkSize());
        if (config.clustering().cacheMode().isSynchronous()) {
            legacy.clustering().sync().replTimeout(config.clustering().sync().replTimeout());
        }
        for (InterceptorConfiguration interceptor : config.customInterceptors().interceptors()) {
            FluentConfiguration.CustomInterceptorPosition position = legacy.customInterceptors().add(interceptor.interceptor());
            if (interceptor.after() != null) {
                position.after(interceptor.after());
            }
            if (interceptor.index() > -1) {
                position.atIndex(interceptor.index());
            }
            if (interceptor.before() != null) {
                position.before(interceptor.before());
            }
            if (interceptor.first()) {
                position.first();
            }
            if (!interceptor.last()) continue;
            position.last();
        }
        legacy.dataContainer().dataContainer(config.dataContainer().dataContainer()).withProperties(config.dataContainer().properties());
        if (config.deadlockDetection().enabled()) {
            legacy.deadlockDetection().spinDuration(config.deadlockDetection().spinDuration());
        } else {
            legacy.deadlockDetection().disable();
        }
        legacy.eviction().maxEntries(config.eviction().maxEntries()).strategy(config.eviction().strategy()).threadPolicy(config.eviction().threadPolicy());
        legacy.expiration().lifespan(config.expiration().lifespan()).maxIdle(config.expiration().maxIdle()).reaperEnabled(config.expiration().reaperEnabled()).wakeUpInterval(config.expiration().wakeUpInterval());
        if (config.indexing().enabled()) {
            FluentConfiguration.IndexingConfig indexing = legacy.indexing();
            indexing.indexLocalOnly(config.indexing().indexLocalOnly());
            indexing.withProperties(config.indexing().properties());
        } else {
            legacy.indexing().disable();
        }
        if (config.invocationBatching().enabled()) {
            legacy.invocationBatching();
        } else {
            legacy.invocationBatching().disable();
        }
        if (config.jmxStatistics().enabled()) {
            legacy.jmxStatistics();
        }
        legacy.loaders().passivation(config.loaders().passivation()).preload(config.loaders().preload()).shared(config.loaders().shared());
        for (CacheLoaderConfiguration loader : config.loaders().cacheLoaders()) {
            CacheLoaderConfig clc = LegacyConfigurationAdaptor.adapt(loader);
            legacy.loaders().addCacheLoader(clc);
        }
        legacy.locking().concurrencyLevel(config.locking().concurrencyLevel()).isolationLevel(config.locking().isolationLevel()).lockAcquisitionTimeout(config.locking().lockAcquisitionTimeout()).useLockStriping(config.locking().useLockStriping()).writeSkewCheck(config.locking().writeSkewCheck());
        if (config.storeAsBinary().enabled()) {
            legacy.storeAsBinary().storeKeysAsBinary(config.storeAsBinary().storeKeysAsBinary()).storeValuesAsBinary(config.storeAsBinary().storeValuesAsBinary());
        } else {
            legacy.storeAsBinary().disable();
        }
        legacy.transaction().autoCommit(config.transaction().autoCommit()).cacheStopTimeout((int)config.transaction().cacheStopTimeout()).eagerLockSingleNode(config.transaction().eagerLockingSingleNode()).lockingMode(config.transaction().lockingMode()).syncCommitPhase(config.transaction().syncCommitPhase()).syncRollbackPhase(config.transaction().syncRollbackPhase()).transactionManagerLookup(config.transaction().transactionManagerLookup()).transactionMode(config.transaction().transactionMode()).transactionSynchronizationRegistryLookup(config.transaction().transactionSynchronizationRegistryLookup()).useEagerLocking(config.transaction().useEagerLocking()).useSynchronization(config.transaction().useSynchronization()).use1PcForAutoCommitTransactions(config.transaction().use1PcForAutoCommitTransactions());
        if (config.transaction().recovery().enabled()) {
            legacy.transaction().recovery().recoveryInfoCacheName(config.transaction().recovery().recoveryInfoCacheName());
        }
        legacy.unsafe().unreliableReturnValues(config.unsafe().unreliableReturnValues());
        if (config.versioning().enabled()) {
            legacy.versioning().enable().versioningScheme(config.versioning().scheme());
        }
        return legacy.build();
    }

    public static CacheLoaderConfig adapt(CacheLoaderConfiguration loader) {
        Properties p;
        CacheLoaderConfig clc = null;
        if (loader instanceof LegacyLoaderAdapter) {
            return ((LegacyLoaderAdapter)((Object)loader)).adapt();
        }
        if (loader instanceof CacheStoreConfiguration) {
            if (loader instanceof LegacyStoreConfiguration) {
                LegacyStoreConfiguration store = (LegacyStoreConfiguration)loader;
                CacheLoader cacheStore = store.cacheStore();
                clc = LegacyConfigurationAdaptor.getLoaderConfig(loader, cacheStore);
            }
            CacheStoreConfig csc = (CacheStoreConfig)clc;
            CacheStoreConfiguration store = (CacheStoreConfiguration)loader;
            LegacyConfigurationAdaptor.adapt(store, csc);
        } else if (loader instanceof LegacyLoaderConfiguration) {
            CacheLoader cacheLoader = ((LegacyLoaderConfiguration)loader).cacheLoader();
            clc = LegacyConfigurationAdaptor.getLoaderConfig(loader, cacheLoader);
        }
        if (clc instanceof AbstractCacheStoreConfig) {
            AbstractCacheStoreConfig acsc = (AbstractCacheStoreConfig)clc;
            Properties p2 = loader.properties();
            acsc.setProperties(p2);
            if (p2 != null) {
                XmlConfigHelper.setValues(clc, p2, false, true);
            }
            if (loader instanceof LegacyStoreConfiguration) {
                acsc.purgerThreads(((LegacyStoreConfiguration)loader).purgerThreads());
            }
        } else if (clc instanceof CacheLoaderConfig && (p = loader.properties()) != null) {
            XmlConfigHelper.setValues(clc, p, false, true);
        }
        return clc;
    }

    private static CacheLoaderConfig getLoaderConfig(CacheLoaderConfiguration loader, CacheLoader cacheLoader) {
        if (cacheLoader.getClass().isAnnotationPresent(CacheLoaderMetadata.class)) {
            return Util.getInstance(cacheLoader.getClass().getAnnotation(CacheLoaderMetadata.class).configurationClass());
        }
        AbstractCacheStoreConfig acsc = new AbstractCacheStoreConfig();
        if (loader instanceof LegacyStoreConfiguration) {
            acsc.setCacheLoaderClassName(((LegacyStoreConfiguration)loader).cacheStore().getClass().getName());
        } else {
            acsc.setCacheLoaderClassName(((LegacyLoaderConfiguration)loader).cacheLoader().getClass().getName());
        }
        return acsc;
    }

    public static Configuration adapt(org.infinispan.config.Configuration legacy) {
        if (legacy == null) {
            return null;
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.valueOf(legacy.getCacheMode().name()));
        if (!legacy.getCacheMode().isSynchronous()) {
            if (legacy.isUseAsyncMarshalling()) {
                builder.clustering().async().asyncMarshalling();
            } else {
                builder.clustering().async().syncMarshalling();
            }
            builder.clustering().async().replQueue((ReplicationQueue)Util.getInstance(legacy.getReplQueueClass(), legacy.getClassLoader())).replQueueInterval(legacy.getReplQueueInterval()).replQueueMaxElements(legacy.getReplQueueMaxElements()).useReplQueue(legacy.isUseReplQueue());
        }
        if (legacy.isCustomConsistentHashClass()) {
            builder.clustering().hash().consistentHash((ConsistentHash)Util.getInstance(legacy.getConsistentHashClass(), legacy.getClassLoader()));
        }
        builder.clustering().stateTransfer().fetchInMemoryState(legacy.isFetchInMemoryState()).timeout(legacy.getStateRetrievalTimeout()).chunkSize(legacy.getStateRetrievalChunkSize());
        if (legacy.isHashActivated()) {
            builder.clustering().hash().numOwners(legacy.getNumOwners()).rehashEnabled(legacy.isRehashEnabled()).rehashRpcTimeout(legacy.getRehashRpcTimeout()).rehashWait(legacy.getRehashWaitTime()).groups().enabled(legacy.isGroupsEnabled()).withGroupers(legacy.getGroupers());
        }
        if (legacy.isL1CacheEnabled() && legacy.getCacheMode().isDistributed()) {
            builder.clustering().l1().enable();
            builder.clustering().l1().onRehash(legacy.isL1OnRehash());
        } else {
            builder.clustering().l1().disable();
        }
        builder.clustering().l1().invalidationThreshold(legacy.getL1InvalidationThreshold()).lifespan(legacy.getL1Lifespan()).cleanupTaskFrequency(legacy.getL1InvalidationCleanupTaskFrequency());
        if (legacy.getCacheMode().isDistributed()) {
            builder.clustering().stateTransfer().fetchInMemoryState(legacy.isRehashEnabled()).timeout(legacy.getRehashWaitTime());
        } else if (legacy.getCacheMode().isClustered()) {
            builder.clustering().stateTransfer().fetchInMemoryState(legacy.isFetchInMemoryState()).timeout(legacy.getStateRetrievalTimeout());
        }
        builder.clustering().stateTransfer().chunkSize(legacy.getStateRetrievalChunkSize());
        if (legacy.getCacheMode().isSynchronous()) {
            builder.clustering().sync().replTimeout(legacy.getSyncReplTimeout());
        }
        for (CustomInterceptorConfig interceptor : legacy.getCustomInterceptors()) {
            InterceptorConfigurationBuilder interceptorConfigurationBuilder = builder.clustering().customInterceptors().addInterceptor();
            interceptorConfigurationBuilder.interceptor(interceptor.getInterceptor());
            if (interceptor.getAfter() != null && !interceptor.getAfter().isEmpty()) {
                interceptorConfigurationBuilder.after(Util.loadClass(interceptor.getAfter(), legacy.getClassLoader()));
                continue;
            }
            if (interceptor.getBefore() != null && !interceptor.getBefore().isEmpty()) {
                interceptorConfigurationBuilder.before(Util.loadClass(interceptor.getBefore(), legacy.getClassLoader()));
                continue;
            }
            if (!interceptor.getPositionAsString().equals(InterceptorConfiguration.Position.OTHER_THAN_FIRST_OR_LAST.toString())) {
                interceptorConfigurationBuilder.position(InterceptorConfiguration.Position.valueOf(interceptor.getPositionAsString()));
                continue;
            }
            interceptorConfigurationBuilder.index(interceptor.getIndex());
        }
        builder.dataContainer().dataContainer(legacy.getDataContainer()).withProperties(legacy.getDataContainerProperties());
        if (legacy.isDeadlockDetectionEnabled()) {
            builder.deadlockDetection().enable().spinDuration(legacy.getDeadlockDetectionSpinDuration());
        } else {
            builder.deadlockDetection().disable();
        }
        builder.eviction().maxEntries(legacy.getEvictionMaxEntries()).strategy(legacy.getEvictionStrategy()).threadPolicy(legacy.getEvictionThreadPolicy());
        builder.expiration().lifespan(legacy.getExpirationLifespan()).maxIdle(legacy.getExpirationMaxIdle()).reaperEnabled(legacy.isExpirationReaperEnabled()).wakeUpInterval(legacy.getExpirationWakeUpInterval());
        if (legacy.isIndexingEnabled()) {
            builder.indexing().enable().indexLocalOnly(legacy.isIndexLocalOnly()).withProperties(legacy.getIndexingProperties());
        } else {
            builder.indexing().disable();
        }
        if (legacy.isInvocationBatchingEnabled()) {
            builder.invocationBatching().enable();
        } else {
            builder.invocationBatching().disable();
        }
        builder.jmxStatistics().enabled(legacy.isExposeJmxStatistics());
        builder.loaders().passivation(legacy.isCacheLoaderPassivation()).preload(legacy.isCacheLoaderPreload()).shared(legacy.isCacheLoaderShared());
        for (CacheLoaderConfig clc : legacy.getCacheLoaders()) {
            LegacyConfigurationAdaptor.adapt(legacy.getClassLoader(), builder, clc);
        }
        builder.locking().concurrencyLevel(legacy.getConcurrencyLevel()).isolationLevel(legacy.getIsolationLevel()).lockAcquisitionTimeout(legacy.getLockAcquisitionTimeout()).useLockStriping(legacy.isUseLockStriping()).writeSkewCheck(legacy.isWriteSkewCheck());
        if (legacy.isStoreAsBinary()) {
            builder.storeAsBinary().enable().storeKeysAsBinary(legacy.isStoreKeysAsBinary()).storeValuesAsBinary(legacy.isStoreValuesAsBinary());
        } else {
            builder.storeAsBinary().disable();
        }
        builder.transaction().autoCommit(legacy.isTransactionAutoCommit()).cacheStopTimeout(legacy.getCacheStopTimeout()).eagerLockingSingleNode(legacy.isEagerLockSingleNode()).lockingMode(legacy.getTransactionLockingMode()).syncCommitPhase(legacy.isSyncCommitPhase()).syncRollbackPhase(legacy.isSyncRollbackPhase()).transactionMode(legacy.getTransactionMode()).transactionSynchronizationRegistryLookup(legacy.getTransactionSynchronizationRegistryLookup()).useEagerLocking(legacy.isUseEagerLocking()).useSynchronization(legacy.isUseSynchronizationForTransactions()).use1PcForAutoCommitTransactions(legacy.isUse1PcForAutoCommitTransactions());
        TransactionManagerLookup tmLookup = legacy.getTransactionManagerLookup();
        if (tmLookup != null) {
            builder.transaction().transactionManagerLookup(tmLookup);
        } else {
            String tmLookupClass = legacy.getTransactionManagerLookupClass();
            if (tmLookupClass != null) {
                builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance(tmLookupClass, Thread.currentThread().getContextClassLoader()));
            }
        }
        builder.versioning().enabled(legacy.isEnableVersioning()).scheme(legacy.getVersioningScheme());
        builder.transaction().recovery().enabled(legacy.isTransactionRecoveryEnabled());
        builder.unsafe().unreliableReturnValues(legacy.isUnsafeUnreliableReturnValues());
        return builder.build();
    }

    public static void adapt(ClassLoader cl, ConfigurationBuilder builder, CacheLoaderConfig clc) {
        CacheStoreConfig csc;
        AbstractLoaderConfigurationBuilder loaderBuilder = null;
        if (clc instanceof ClusterCacheLoaderConfig) {
            ClusterCacheLoaderConfig cclc = (ClusterCacheLoaderConfig)clc;
            ClusterCacheLoaderConfigurationBuilder cclBuilder = builder.loaders().addClusterCacheLoader();
            cclBuilder.remoteCallTimeout(cclc.getRemoteCallTimeout());
            loaderBuilder = cclBuilder;
        } else if (clc instanceof FileCacheStoreConfig) {
            csc = (FileCacheStoreConfig)clc;
            FileCacheStoreConfigurationBuilder fcsBuilder = builder.loaders().addFileCacheStore();
            fcsBuilder.fetchPersistentState(((AbstractCacheStoreConfig)csc).isFetchPersistentState());
            fcsBuilder.ignoreModifications(((AbstractCacheStoreConfig)csc).isIgnoreModifications());
            fcsBuilder.purgeOnStartup(((AbstractCacheStoreConfig)csc).isPurgeOnStartup());
            fcsBuilder.purgerThreads(((AbstractCacheStoreConfig)csc).getPurgerThreads());
            fcsBuilder.purgeSynchronously(((AbstractCacheStoreConfig)csc).isPurgeSynchronously());
            fcsBuilder.location(((FileCacheStoreConfig)csc).getLocation());
            fcsBuilder.fsyncInterval(((FileCacheStoreConfig)csc).getFsyncInterval());
            fcsBuilder.fsyncMode(FileCacheStoreConfigurationBuilder.FsyncMode.valueOf(((FileCacheStoreConfig)csc).getFsyncMode().name()));
            fcsBuilder.streamBufferSize(((FileCacheStoreConfig)csc).getStreamBufferSize());
            loaderBuilder = fcsBuilder;
        } else if (clc instanceof CacheStoreConfig) {
            LegacyStoreConfigurationBuilder tmpStoreBuilder = builder.loaders().addStore();
            tmpStoreBuilder.cacheStore((CacheStore)Util.getInstance(clc.getCacheLoaderClassName(), cl));
            CacheStoreConfig csc2 = (CacheStoreConfig)clc;
            tmpStoreBuilder.fetchPersistentState(csc2.isFetchPersistentState());
            tmpStoreBuilder.ignoreModifications(csc2.isIgnoreModifications());
            tmpStoreBuilder.purgeOnStartup(csc2.isPurgeOnStartup());
            tmpStoreBuilder.purgerThreads(csc2.getPurgerThreads());
            tmpStoreBuilder.purgeSynchronously(csc2.isPurgeSynchronously());
            loaderBuilder = tmpStoreBuilder;
            if (clc instanceof AbstractCacheStoreConfig) {
                tmpStoreBuilder.withProperties(((AbstractCacheLoaderConfig)clc).getProperties());
            }
        } else {
            LegacyLoaderConfigurationBuilder tmpLoaderBuilder = builder.loaders().addLoader();
            tmpLoaderBuilder.cacheLoader((CacheLoader)Util.getInstance(clc.getCacheLoaderClassName(), cl));
            loaderBuilder = tmpLoaderBuilder;
        }
        if (clc instanceof CacheStoreConfig) {
            csc = (CacheStoreConfig)clc;
            CacheStoreConfigurationBuilder storeBuilder = (CacheStoreConfigurationBuilder)((Object)loaderBuilder);
            storeBuilder.async().enabled(csc.getAsyncStoreConfig().isEnabled());
            storeBuilder.async().flushLockTimeout(csc.getAsyncStoreConfig().getFlushLockTimeout());
            storeBuilder.async().modificationQueueSize(csc.getAsyncStoreConfig().getModificationQueueSize());
            storeBuilder.async().shutdownTimeout(csc.getAsyncStoreConfig().getShutdownTimeout());
            storeBuilder.async().threadPoolSize(csc.getAsyncStoreConfig().getThreadPoolSize());
            storeBuilder.singletonStore().enabled(csc.getSingletonStoreConfig().isSingletonStoreEnabled());
            storeBuilder.singletonStore().pushStateTimeout(csc.getSingletonStoreConfig().getPushStateTimeout());
            storeBuilder.singletonStore().pushStateWhenCoordinator(csc.getSingletonStoreConfig().isPushStateWhenCoordinator());
        }
    }

    public static void adapt(CacheStoreConfiguration config, CacheStoreConfig legacy) {
        legacy.fetchPersistentState(config.fetchPersistentState());
        legacy.ignoreModifications(config.ignoreModifications());
        legacy.purgeOnStartup(config.purgeOnStartup());
        legacy.purgeSynchronously(config.purgeSynchronously());
        legacy.purgerThreads(config.purgerThreads());
        legacy.getAsyncStoreConfig().setEnabled(config.async().enabled());
        legacy.getAsyncStoreConfig().flushLockTimeout(config.async().flushLockTimeout());
        legacy.getAsyncStoreConfig().modificationQueueSize(config.async().modificationQueueSize());
        legacy.getAsyncStoreConfig().shutdownTimeout(config.async().shutdownTimeout());
        legacy.getAsyncStoreConfig().threadPoolSize(config.async().threadPoolSize());
        legacy.getSingletonStoreConfig().enabled(config.singletonStore().enabled());
        legacy.getSingletonStoreConfig().pushStateTimeout(config.singletonStore().pushStateTimeout());
        legacy.getSingletonStoreConfig().pushStateWhenCoordinator(config.singletonStore().pushStateWhenCoordinator());
        if (config instanceof LockSupportStoreConfiguration) {
            LockSupportStoreConfiguration lockConfig = (LockSupportStoreConfiguration)config;
            LockSupportCacheStoreConfig lockLegacy = (LockSupportCacheStoreConfig)legacy;
            lockLegacy.setLockAcquistionTimeout(lockConfig.lockAcquistionTimeout());
            lockLegacy.setLockConcurrencyLevel(lockConfig.lockConcurrencyLevel());
        }
    }
}

