/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.upgrade;

import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.upgrade.SourceMigrator;
import org.infinispan.upgrade.TargetMigrator;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="RollingUpgradeManager", description="This component handles the control hooks to handle migrating data from one version of Infinispan to another")
@Scope(value=Scopes.NAMED_CACHE)
@SurvivesRestarts
public class RollingUpgradeManager {
    private static final Log log = LogFactory.getLog(RollingUpgradeManager.class);
    private final Set<SourceMigrator> sourceMigrators = new HashSet<SourceMigrator>(2);
    private Cache<Object, Object> cache;

    @Inject
    public void initialize(Cache<Object, Object> cache) {
        this.cache = cache;
    }

    @ManagedOperation(description="Dumps the global known keyset to a well-known key for retrieval by the upgrade process", displayName="Dumps the global known keyset")
    public void recordKnownGlobalKeyset() {
        for (SourceMigrator m : this.sourceMigrators) {
            m.recordKnownGlobalKeyset();
        }
    }

    @ManagedOperation(description="Synchronizes data from the old cluster to this using the specified migrator", displayName="Synchronizes data from the old cluster to this using the specified migrator")
    public long synchronizeData(@Parameter(name="migratorName", description="The name of the migrator to use") String migratorName) throws Exception {
        TargetMigrator migrator = this.getMigrator(migratorName);
        long start = System.currentTimeMillis();
        long count = migrator.synchronizeData(this.cache);
        log.entriesMigrated(count, this.cache.getName(), Util.prettyPrintTime(System.currentTimeMillis() - start));
        return count;
    }

    @ManagedOperation(description="Disconnects the target cluster from the source cluster according to the specified migrator", displayName="Disconnects the target cluster from the source cluster")
    public void disconnectSource(@Parameter(name="migratorName", description="The name of the migrator to use") String migratorName) throws Exception {
        TargetMigrator migrator = this.getMigrator(migratorName);
        migrator.disconnectSource(this.cache);
    }

    private TargetMigrator getMigrator(String name) throws Exception {
        ClassLoader cl = this.cache.getCacheManager().getCacheManagerConfiguration().classLoader();
        for (TargetMigrator m : ServiceLoader.load(TargetMigrator.class, cl)) {
            if (!name.equalsIgnoreCase(m.getName())) continue;
            return m;
        }
        throw log.unknownMigrator(name);
    }

    public void addSourceMigrator(SourceMigrator migrator) {
        this.sourceMigrators.add(migrator);
    }
}

