/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import org.hibernate.stat.QueryStatistics;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.jpa.hibernate4.management.ManagementLookup;
import org.jboss.as.jpa.hibernate4.management.QueryName;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelNode;

public abstract class QueryMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;

    private QueryMetricsHandler(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.handleQueryStatistics(context, operation);
        context.stepCompleted();
    }

    protected abstract void handle(QueryStatistics var1, OperationContext var2, String var3, String var4);

    private void handleQueryStatistics(OperationContext context, ModelNode operation) {
        String[] originalQueryNames;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String puResourceName = address.getElement(address.size() - 2).getValue();
        String displayQueryName = address.getLastElement().getValue();
        ManagementLookup stats = ManagementLookup.create(this.persistenceUnitRegistry, puResourceName);
        if (stats != null && (originalQueryNames = stats.getStatistics().getQueries()) != null) {
            for (String originalQueryName : originalQueryNames) {
                if (!QueryName.queryName(originalQueryName).getDisplayName().equals(displayQueryName)) continue;
                QueryStatistics statistics = stats.getStatistics().getQueryStatistics(originalQueryName);
                this.handle(statistics, context, operation.require("name").asString(), originalQueryName);
                break;
            }
        }
    }

    static final QueryMetricsHandler getExecutionCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                long count = statistics.getExecutionCount();
                context.getResult().set(count);
            }
        };
    }

    static final QueryMetricsHandler getCacheHitCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                long count = statistics.getCacheHitCount();
                context.getResult().set(count);
            }
        };
    }

    static final QueryMetricsHandler getCachePutCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                long count = statistics.getCachePutCount();
                context.getResult().set(count);
            }
        };
    }

    static final QueryMetricsHandler getCacheMissCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                long count = statistics.getCacheMissCount();
                context.getResult().set(count);
            }
        };
    }

    static final QueryMetricsHandler getExecutionRowCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                long count = statistics.getExecutionRowCount();
                context.getResult().set(count);
            }
        };
    }

    static final QueryMetricsHandler getExecutionAvgTime(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                long count = statistics.getExecutionAvgTime();
                context.getResult().set(count);
            }
        };
    }

    static final QueryMetricsHandler getExecutionMaxTime(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                long count = statistics.getExecutionMaxTime();
                context.getResult().set(count);
            }
        };
    }

    static final QueryMetricsHandler getExecutionMinTime(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                long count = statistics.getExecutionMinTime();
                context.getResult().set(count);
            }
        };
    }

    public static OperationStepHandler getOriginalName(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new QueryMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(QueryStatistics statistics, OperationContext context, String attributeName, String originalQueryName) {
                context.getResult().set(originalQueryName);
            }
        };
    }
}

