/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.ModuleManagerImpl;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.FrameworkModuleProvider;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.SystemPaths;
import org.jboss.osgi.resolver.XEnvironment;

public class ModuleManagerPlugin
extends AbstractIntegrationService<ModuleManager> {
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<SystemPaths> injectedSystemPaths = new InjectedValue();
    private final InjectedValue<FrameworkModuleProvider> injectedFrameworkModule = new InjectedValue();
    private final InjectedValue<FrameworkModuleLoader> injectedModuleLoader = new InjectedValue();

    public ModuleManagerPlugin() {
        super(IntegrationServices.MODULE_MANGER);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<ModuleManager> builder) {
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(IntegrationServices.FRAMEWORK_MODULE_LOADER, FrameworkModuleLoader.class, this.injectedModuleLoader);
        builder.addDependency(IntegrationServices.FRAMEWORK_MODULE_PROVIDER, FrameworkModuleProvider.class, this.injectedFrameworkModule);
        builder.addDependency(IntegrationServices.SYSTEM_PATHS, SystemPaths.class, this.injectedSystemPaths);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected ModuleManager createServiceValue(StartContext startContext) throws StartException {
        FrameworkModuleProvider moduleProvider = (FrameworkModuleProvider)this.injectedFrameworkModule.getValue();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        SystemPaths syspaths = (SystemPaths)this.injectedSystemPaths.getValue();
        FrameworkModuleLoader moduleLoader = (FrameworkModuleLoader)this.injectedModuleLoader.getValue();
        return new ModuleManagerImpl(env, syspaths, moduleProvider, moduleLoader);
    }
}

