/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.lock;

import java.io.Serializable;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.ClusteringApiMessages;
import org.jboss.as.clustering.GroupMembershipNotifier;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.lock.AbstractClusterLockSupport;
import org.jboss.as.clustering.lock.ClusterLockState;
import org.jboss.as.clustering.lock.LocalLockHandler;
import org.jboss.as.clustering.lock.RemoteLockResponse;

public class NonGloballyExclusiveClusterLockSupport
extends AbstractClusterLockSupport {
    public NonGloballyExclusiveClusterLockSupport(String serviceHAName, GroupRpcDispatcher rpcDispatcher, GroupMembershipNotifier membershipNotifier, LocalLockHandler handler) {
        super(serviceHAName, rpcDispatcher, membershipNotifier, handler);
    }

    @Override
    public void unlock(Serializable lockId) {
        ClusterNode myself = this.getLocalClusterNode();
        if (myself == null) {
            throw ClusteringApiMessages.MESSAGES.invalidMethodCall("start()", "unlock()");
        }
        ClusterLockState lockState = this.getClusterLockState(lockId, false);
        if (lockState != null && myself.equals(lockState.getHolder())) {
            this.getLocalHandler().unlockFromCluster(lockId, myself);
            lockState.release();
            try {
                this.getGroupRpcDispatcher().callMethodOnCluster(this.getServiceHAName(), "releaseRemoteLock", new Object[]{lockId, myself}, RELEASE_REMOTE_LOCK_TYPES, true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ClusteringApiMessages.MESSAGES.remoteLockReleaseFailure(e);
            }
        }
    }

    @Override
    protected ClusterLockState getClusterLockState(Serializable categoryName) {
        return this.getClusterLockState(categoryName, true);
    }

    @Override
    protected RemoteLockResponse yieldLock(ClusterLockState lockState, ClusterNode caller, long timeout) {
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.REJECT, lockState.getHolder());
    }

    @Override
    protected RemoteLockResponse handleLockSuccess(ClusterLockState lockState, ClusterNode caller) {
        this.recordLockHolder(lockState, caller);
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.OK);
    }

    @Override
    protected RemoteLockResponse getRemoteLockResponseForUnknownLock(Serializable lockName, ClusterNode caller, long timeout) {
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.OK);
    }
}

