/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.vfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.as.jdr.util.WildcardPattern;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.util.MatchAllVirtualFileFilter;

public class Filters {
    public static VirtualFileFilter TRUE = MatchAllVirtualFileFilter.INSTANCE;

    public static VirtualFileFilter not(final VirtualFileFilter filter) {
        return new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return !filter.accepts(file);
            }
        };
    }

    public static VirtualFileFilter and(final VirtualFileFilter ... filters) {
        return new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                for (VirtualFileFilter f : filters) {
                    if (f.accepts(file)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static VirtualFileFilter or(final VirtualFileFilter ... filters) {
        return new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                for (VirtualFileFilter f : filters) {
                    if (!f.accepts(file)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static VirtualFileFilter wildcard(final String p) {
        return new VirtualFileFilter(){
            private WildcardPattern pattern;
            {
                this.pattern = new WildcardPattern(p);
            }

            public boolean accepts(VirtualFile file) {
                return this.pattern.matches(file.getPathName());
            }
        };
    }

    public static BlacklistFilter wildcardBlackList() {
        return new WildcardBlacklistFilter();
    }

    public static BlacklistFilter wildcardBlacklistFilter(String ... patterns) {
        return new WildcardBlacklistFilter(patterns);
    }

    public static BlacklistFilter regexBlackList() {
        return new RegexBlacklistFilter();
    }

    public static BlacklistFilter regexBlackList(String ... patterns) {
        return new RegexBlacklistFilter(patterns);
    }

    public static VirtualFileFilter suffix(final String s) {
        return new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.getPathName().endsWith(s);
            }
        };
    }

    private static class RegexBlacklistFilter
    implements BlacklistFilter {
        private final List<Pattern> patterns;

        public RegexBlacklistFilter() {
            this.patterns = Arrays.asList(Pattern.compile(".*-users.properties"));
        }

        public RegexBlacklistFilter(String ... patterns) {
            this.patterns = new ArrayList<Pattern>(patterns.length);
            this.add(patterns);
        }

        public boolean accepts(VirtualFile file) {
            for (Pattern p : this.patterns) {
                if (!p.matcher(file.getName()).matches()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void add(String ... patterns) {
            for (String p : patterns) {
                this.patterns.add(Pattern.compile(p));
            }
        }
    }

    private static class WildcardBlacklistFilter
    implements BlacklistFilter {
        private final List<WildcardPattern> patterns;

        public WildcardBlacklistFilter() {
            this.patterns = new ArrayList<WildcardPattern>();
            this.patterns.add(new WildcardPattern("*-users.properties"));
        }

        public WildcardBlacklistFilter(String ... patterns) {
            this.patterns = new ArrayList<WildcardPattern>(patterns.length);
            this.add(patterns);
        }

        public boolean accepts(VirtualFile file) {
            for (WildcardPattern p : this.patterns) {
                if (!p.matches(file.getName())) continue;
                return false;
            }
            return true;
        }

        @Override
        public void add(String ... patterns) {
            for (String p : patterns) {
                this.patterns.add(new WildcardPattern(p));
            }
        }
    }

    public static interface BlacklistFilter
    extends VirtualFileFilter {
        public void add(String ... var1);
    }
}

