/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.crypto.dsig.Reference;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class UsernameTokenSignedAction
implements Action {
    @Override
    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        CallbackHandler callbackHandler = handler.getPasswordCallbackHandler(reqData);
        WSPasswordCallback passwordCallback = handler.getPasswordCB(reqData.getUsername(), actionToDo, callbackHandler, reqData);
        WSSecUsernameToken builder = new WSSecUsernameToken(reqData.getWssConfig());
        if (reqData.isUseDerivedKey()) {
            int iterations = reqData.getDerivedKeyIterations();
            boolean useMac = reqData.isUseDerivedKeyForMAC();
            builder.addDerivedKey(useMac, null, iterations);
        } else {
            builder.setPasswordType(reqData.getPwType());
            builder.setSecretKeyLength(reqData.getSecretKeyLength());
        }
        builder.setUserInfo(reqData.getUsername(), passwordCallback.getPassword());
        builder.addCreated();
        builder.addNonce();
        builder.prepare(doc);
        WSSecSignature sign = new WSSecSignature(reqData.getWssConfig());
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        sign.setCustomTokenId(builder.getId());
        sign.setSecretKey(builder.getSecretKey());
        sign.setKeyIdentifierType(9);
        if (reqData.getSigDigestAlgorithm() != null) {
            sign.setDigestAlgo(reqData.getSigDigestAlgorithm());
        }
        if (reqData.getSigAlgorithm() != null) {
            sign.setSignatureAlgorithm(reqData.getSigAlgorithm());
        } else {
            sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        }
        sign.prepare(doc, null, reqData.getSecHeader());
        List<WSEncryptionPart> parts = null;
        if (reqData.getSignatureParts().size() > 0) {
            parts = reqData.getSignatureParts();
        } else {
            SOAPConstants soapConstants = reqData.getSoapConstants();
            if (soapConstants == null) {
                soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
            }
            parts = new ArrayList<WSEncryptionPart>();
            WSEncryptionPart encP = new WSEncryptionPart("Body", soapConstants.getEnvelopeURI(), "Content");
            parts.add(encP);
        }
        List<Reference> referenceList = sign.addReferencesToSign(parts, reqData.getSecHeader());
        try {
            sign.computeSignature(referenceList);
            reqData.getSignatureValues().add(sign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Error during UsernameTokenSignature", e);
        }
        builder.prependToHeader(reqData.getSecHeader());
    }
}

