/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.NoSuchEntityException;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.timerservice.spi.BeanRemovedException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class EntityBeanAssociatingInterceptor
extends AbstractEJBInterceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new EntityBeanAssociatingInterceptor());

    public Object processInvocation(InterceptorContext context) throws Exception {
        EntityBeanComponentInstance instance;
        EntityBeanComponent component = EntityBeanAssociatingInterceptor.getComponent(context, EntityBeanComponent.class);
        Object primaryKey = context.getPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
        if (primaryKey == null) {
            throw EjbMessages.MESSAGES.primaryKeyIsNull();
        }
        try {
            instance = component.getCache().get(primaryKey);
            if (instance.isRemoved()) {
                component.getCache().release(instance, true);
                throw EjbMessages.MESSAGES.instanceWasRemoved(component.getComponentName(), primaryKey);
            }
        }
        catch (NoSuchEntityException e) {
            if (context.getPrivateData(InvocationType.class) == InvocationType.TIMER) {
                throw new BeanRemovedException(e);
            }
            throw e;
        }
        try {
            context.putPrivateData(ComponentInstance.class, (Object)instance);
            Object e = context.proceed();
            return e;
        }
        catch (Exception ex) {
            if (component.getApplicationException(ex.getClass(), context.getMethod()) != null) {
                throw ex;
            }
            if (ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EjbLogger.ROOT_LOGGER.trace("Discarding bean " + primaryKey + " because of exception", ex);
                }
                instance.discard();
            }
            throw ex;
        }
        catch (Error e) {
            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Discarding bean " + primaryKey + " because of error", e);
            }
            instance.discard();
            throw e;
        }
        catch (Throwable t) {
            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Discarding bean " + primaryKey + " because of Throwable", t);
            }
            instance.discard();
            throw new RuntimeException(t);
        }
        finally {
            context.putPrivateData(ComponentInstance.class, null);
        }
    }
}

