/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.clustering.web.OutgoingAttributeGranularitySessionData;
import org.jboss.as.clustering.web.SessionAttributeMarshaller;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorage;

public class FineSessionAttributeStorage
implements SessionAttributeStorage<OutgoingAttributeGranularitySessionData> {
    private final SessionAttributeMarshaller marshaller;

    public FineSessionAttributeStorage(SessionAttributeMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public void store(Map<Object, Object> map, OutgoingAttributeGranularitySessionData sessionData) throws IOException {
        Set removed;
        Map modified = sessionData.getModifiedSessionAttributes();
        if (modified != null) {
            for (Map.Entry entry : modified.entrySet()) {
                map.put(entry.getKey(), this.marshaller.marshal(entry.getValue()));
            }
        }
        if ((removed = sessionData.getRemovedSessionAttributes()) != null) {
            for (String attribute : removed) {
                map.remove(attribute);
            }
        }
    }

    @Override
    public Map<String, Object> load(Map<Object, Object> data) throws IOException, ClassNotFoundException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            String attribute = (String)key;
            result.put(attribute, this.marshaller.unmarshal(entry.getValue()));
        }
        return result;
    }
}

