/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.connector.deployers.ra.processors.IronJacamarDeploymentParsingProcessor;
import org.jboss.as.connector.deployers.ra.processors.ParsedRaDeploymentProcessor;
import org.jboss.as.connector.deployers.ra.processors.RaDeploymentParsingProcessor;
import org.jboss.as.connector.deployers.ra.processors.RaNativeProcessor;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.connector.services.resourceadapters.deployment.InactiveResourceAdapterDeploymentService;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableAdminObject;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableConnDef;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.connector.util.ModelNodeUtil;
import org.jboss.as.connector.util.RaServicesFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.annotation.ResourceRootIndexer;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.Index;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v10.CommonConnDef;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class RaOperationUtil {
    private static final String RAR_EXTENSION = ".rar";
    private static final ServiceName RAR_MODULE = ServiceName.of((String[])new String[]{"rarinsidemodule"});

    public static ModifiableResourceAdapter buildResourceAdaptersObject(OperationContext context, ModelNode operation, String archiveOrModule) throws OperationFailedException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        ArrayList<CommonConnDef> connectionDefinitions = new ArrayList<CommonConnDef>(0);
        ArrayList<CommonAdminObject> adminObjects = new ArrayList<CommonAdminObject>(0);
        TransactionSupportEnum transactionSupport = operation.hasDefined(Constants.TRANSACTION_SUPPORT.getName()) ? TransactionSupportEnum.valueOf((String)operation.get(Constants.TRANSACTION_SUPPORT.getName()).asString()) : null;
        String bootstrapContext = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.BOOTSTRAP_CONTEXT);
        ArrayList<String> beanValidationGroups = null;
        if (operation.hasDefined(Constants.BEANVALIDATION_GROUPS.getName())) {
            beanValidationGroups = new ArrayList<String>(operation.get(Constants.BEANVALIDATION_GROUPS.getName()).asList().size());
            for (ModelNode beanValidation : operation.get(Constants.BEANVALIDATION_GROUPS.getName()).asList()) {
                beanValidationGroups.add(beanValidation.asString());
            }
        }
        ModifiableResourceAdapter ra = new ModifiableResourceAdapter(archiveOrModule, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext);
        return ra;
    }

    public static ModifiableConnDef buildConnectionDefinitionObject(OperationContext context, ModelNode recoveryEnvModel, String poolName, boolean isXa) throws OperationFailedException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, recoveryEnvModel, Constants.CLASS_NAME);
        String jndiName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, recoveryEnvModel, Constants.JNDINAME);
        boolean enabled = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.ENABLED);
        boolean useJavaContext = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.USE_JAVA_CONTEXT);
        boolean useCcm = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.USE_CCM);
        int maxPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE);
        int minPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE);
        boolean prefill = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL);
        boolean useStrictMin = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN);
        String flushStrategyString = org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.resolveModelAttribute(context, recoveryEnvModel).asString();
        FlushStrategy flushStrategy = FlushStrategy.forName((String)flushStrategyString);
        Boolean isSameRM = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.SAME_RM_OVERRIDE);
        boolean interlivng = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.INTERLEAVING);
        boolean padXid = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.PAD_XID);
        boolean wrapXaResource = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.WRAP_XA_RESOURCE);
        boolean noTxSeparatePool = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.NOTXSEPARATEPOOL);
        Integer allocationRetry = ModelNodeUtil.getIntIfSetOrGetDefault(context, recoveryEnvModel, Constants.ALLOCATION_RETRY);
        Long allocationRetryWaitMillis = ModelNodeUtil.getLongIfSetOrGetDefault(context, recoveryEnvModel, Constants.ALLOCATION_RETRY_WAIT_MILLIS);
        Long blockingTimeoutMillis = ModelNodeUtil.getLongIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS);
        Long idleTimeoutMinutes = ModelNodeUtil.getLongIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES);
        Integer xaResourceTimeout = ModelNodeUtil.getIntIfSetOrGetDefault(context, recoveryEnvModel, Constants.XA_RESOURCE_TIMEOUT);
        CommonTimeOutImpl timeOut = new CommonTimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        Object pool = isXa ? new CommonXaPoolImpl(Integer.valueOf(minPoolSize), Integer.valueOf(maxPoolSize), Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, isSameRM, Boolean.valueOf(interlivng), Boolean.valueOf(padXid), Boolean.valueOf(wrapXaResource), Boolean.valueOf(noTxSeparatePool)) : new CommonPoolImpl(Integer.valueOf(minPoolSize), Integer.valueOf(maxPoolSize), Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy);
        String securityDomain = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, recoveryEnvModel, Constants.SECURITY_DOMAIN);
        String securityDomainAndApplication = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, recoveryEnvModel, Constants.SECURITY_DOMAIN_AND_APPLICATION);
        boolean application = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.APPLICATION);
        CommonSecurityImpl security = null;
        if (securityDomain != null || securityDomainAndApplication != null || application) {
            security = new CommonSecurityImpl(securityDomain, securityDomainAndApplication, application);
        }
        Long backgroundValidationMillis = ModelNodeUtil.getLongIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS);
        boolean backgroundValidation = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION);
        boolean useFastFail = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL);
        CommonValidationImpl validation = new CommonValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMillis, Boolean.valueOf(useFastFail));
        String recoveryUsername = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, recoveryEnvModel, Constants.RECOVERY_USERNAME);
        String recoveryPassword = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, recoveryEnvModel, Constants.RECOVERY_PASSWORD);
        String recoverySecurityDomain = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, recoveryEnvModel, Constants.RECOVERY_SECURITY_DOMAIN);
        boolean noRecovery = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, recoveryEnvModel, Constants.NO_RECOVERY);
        Recovery recovery = null;
        if (recoveryUsername != null && recoveryPassword != null || recoverySecurityDomain != null) {
            CredentialImpl credential = null;
            credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
            Extension recoverPlugin = ModelNodeUtil.extractExtension(context, recoveryEnvModel, Constants.RECOVERLUGIN_CLASSNAME, Constants.RECOVERLUGIN_PROPERTIES);
            recovery = new Recovery((Credential)credential, recoverPlugin, Boolean.valueOf(noRecovery));
        }
        ModifiableConnDef connectionDefinition = new ModifiableConnDef(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, (CommonPool)pool, (CommonTimeOut)timeOut, (CommonValidation)validation, (CommonSecurity)security, recovery);
        return connectionDefinition;
    }

    public static ModifiableAdminObject buildAdminObjects(OperationContext context, ModelNode operation, String poolName) throws OperationFailedException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.CLASS_NAME);
        String jndiName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.JNDINAME);
        boolean enabled = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.ENABLED);
        boolean useJavaContext = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.USE_JAVA_CONTEXT);
        ModifiableAdminObject adminObject = new ModifiableAdminObject(configProperties, className, jndiName, poolName, enabled, useJavaContext);
        return adminObject;
    }

    public static boolean deactivateIfActive(OperationContext context, String raName) throws OperationFailedException {
        boolean wasActive = false;
        ServiceName raDeploymentServiceName = ConnectorServices.getDeploymentServiceName(raName);
        Integer identifier = 0;
        if (raName.contains("->")) {
            identifier = Integer.valueOf(raName.substring(raName.indexOf("->") + 2));
            raName = raName.substring(0, raName.indexOf("->"));
        }
        if (raDeploymentServiceName != null) {
            context.removeService(raDeploymentServiceName);
            ConnectorServices.unregisterDeployment(raName, raDeploymentServiceName);
            wasActive = true;
        }
        ConnectorServices.unregisterResourceIdentifier(raName, identifier);
        return wasActive;
    }

    public static void activate(OperationContext context, String raName, String rarName, ServiceVerificationHandler serviceVerificationHandler) throws OperationFailedException {
        ServiceController inactiveRaController;
        ServiceRegistry registry = context.getServiceRegistry(true);
        if (rarName.contains("->")) {
            rarName = rarName.substring(0, rarName.indexOf("->"));
        }
        if ((inactiveRaController = registry.getService(ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{raName}))) == null) {
            throw new OperationFailedException("rar not yet deployed");
        }
        InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment inactive = (InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment)inactiveRaController.getValue();
        ServiceController RaxmlController = registry.getService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName}));
        org.jboss.jca.common.api.metadata.resourceadapter.v10.ResourceAdapter raxml = (org.jboss.jca.common.api.metadata.resourceadapter.v10.ResourceAdapter)RaxmlController.getValue();
        RaServicesFactory.createDeploymentService(inactive.getRegistration(), inactive.getConnectorXmlDescriptor(), inactive.getModule(), inactive.getServiceTarget(), raName, inactive.getDeploymentUnitServiceName(), inactive.getDeployment(), (ResourceAdapter)raxml, inactive.getResource(), serviceVerificationHandler);
    }

    public static ServiceName installRaServices(OperationContext context, ServiceVerificationHandler verificationHandler, String name, ModifiableResourceAdapter resourceAdapter, List<ServiceController<?>> newControllers) {
        ServiceController service;
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceController resourceAdaptersService = context.getServiceRegistry(false).getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
        if (resourceAdaptersService == null) {
            newControllers.add(serviceTarget.addService(ConnectorServices.RESOURCEADAPTERS_SERVICE, (Service)new ResourceAdaptersService()).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        }
        ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{name});
        String bootStrapCtxName = "default";
        if (resourceAdapter.getBootstrapContext() != null && !resourceAdapter.getBootstrapContext().equals("undefined")) {
            bootStrapCtxName = resourceAdapter.getBootstrapContext();
        }
        if ((service = context.getServiceRegistry(true).getService(raServiceName)) == null) {
            ResourceAdapterService raService = new ResourceAdapterService(resourceAdapter);
            newControllers.add(serviceTarget.addService(raServiceName, (Service)raService).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ConnectorServices.RESOURCEADAPTERS_SERVICE, ResourceAdaptersService.ModifiableResourceAdaptors.class, raService.getResourceAdaptersInjector()).addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{bootStrapCtxName})).addListener((ServiceListener)verificationHandler).install());
        }
        return raServiceName;
    }

    public static void installRaServicesAndDeployFromModule(OperationContext context, ServiceVerificationHandler verificationHandler, String name, ModifiableResourceAdapter resourceAdapter, String fullModuleName, List<ServiceController<?>> newControllers) throws OperationFailedException {
        Module module;
        String moduleName;
        ServiceName raServiceName = RaOperationUtil.installRaServices(context, verificationHandler, name, resourceAdapter, newControllers);
        boolean resolveProperties = true;
        ServiceTarget serviceTarget = context.getServiceTarget();
        String slot = "main";
        if (fullModuleName.contains(":")) {
            slot = fullModuleName.substring(fullModuleName.indexOf(":") + 1);
            moduleName = fullModuleName.substring(0, fullModuleName.indexOf(":"));
        } else {
            moduleName = fullModuleName;
        }
        try {
            ModuleIdentifier moduleId = ModuleIdentifier.create((String)moduleName, (String)slot);
            module = Module.getCallerModuleLoader().loadModule(moduleId);
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException(ConnectorMessages.MESSAGES.failedToLoadModuleRA(moduleName), (Throwable)e);
        }
        URL path = module.getExportedResource("META-INF/ra.xml");
        Closeable closable = null;
        try {
            String rarName;
            MountHandle mountHandle;
            if (path.getPath().contains("!")) {
                throw new OperationFailedException(ConnectorMessages.MESSAGES.compressedRarNotSupportedInModuleRA(moduleName));
            }
            VirtualFile child = VFS.getChild((String)path.getPath().split("META-INF")[0]);
            ResourceRoot resourceRoot = new ResourceRoot(child, mountHandle = new MountHandle(closable = VFS.mountReal((File)new File(path.getPath().split("META-INF")[0]), (VirtualFile)child)));
            VirtualFile deploymentRoot = resourceRoot.getRoot();
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return;
            }
            ConnectorXmlDescriptor connectorXmlDescriptor = RaDeploymentParsingProcessor.process(true, deploymentRoot, null, name);
            IronJacamarXmlDescriptor ironJacamarXmlDescriptor = IronJacamarDeploymentParsingProcessor.process(deploymentRoot, true);
            RaNativeProcessor.process(deploymentRoot);
            HashMap<ResourceRoot, Index> annotationIndexes = new HashMap<ResourceRoot, Index>();
            ResourceRootIndexer.indexResourceRoot((ResourceRoot)resourceRoot);
            Index index = (Index)resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index != null) {
                annotationIndexes.put(resourceRoot, index);
            }
            if (ironJacamarXmlDescriptor != null) {
                ConnectorLogger.SUBSYSTEM_RA_LOGGER.forceIJToNull();
                ironJacamarXmlDescriptor = null;
            }
            ServiceName deployerServiceName = ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()});
            ServiceController deployerService = context.getServiceRegistry(true).getService(deployerServiceName);
            if (deployerService == null) {
                ServiceBuilder builder = ParsedRaDeploymentProcessor.process(connectorXmlDescriptor, ironJacamarXmlDescriptor, (ClassLoader)module.getClassLoader(), serviceTarget, annotationIndexes, RAR_MODULE.append(new String[]{name}), verificationHandler);
                newControllers.add(builder.addDependency(raServiceName).setInitialMode(ServiceController.Mode.ACTIVE).install());
            }
            if (fullModuleName.equals(rarName = resourceAdapter.getArchive())) {
                ServiceName serviceName = ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{name});
                InactiveResourceAdapterDeploymentService service = new InactiveResourceAdapterDeploymentService(connectorXmlDescriptor, module, name, name, RAR_MODULE.append(new String[]{name}), null, serviceTarget, null);
                newControllers.add(serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(ConnectorMessages.MESSAGES.failedToLoadModuleRA(moduleName), (Throwable)e);
        }
        finally {
            if (closable != null) {
                try {
                    closable.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

