/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.validators;

import java.text.SimpleDateFormat;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SuffixValidator
extends ModelTypeValidator {
    public SuffixValidator() {
        this(false);
    }

    public SuffixValidator(boolean nullable) {
        super(ModelType.STRING, nullable);
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            String suffix = value.asString();
            try {
                new SimpleDateFormat(suffix);
                if (suffix.contains("s") || suffix.contains("S")) {
                    throw Logging.createOperationFailure(LoggingMessages.MESSAGES.invalidSuffix(suffix));
                }
            }
            catch (IllegalArgumentException e) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.invalidSuffix(suffix));
            }
        }
    }
}

