/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.httpservice;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.httpservice.DefaultHttpContext;
import org.jboss.as.osgi.httpservice.HttpServiceFactory;
import org.jboss.as.osgi.httpservice.ResourceServlet;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

final class HttpServiceImpl
implements HttpService {
    private final HttpServiceFactory.GlobalRegistry registry;
    private final ServerEnvironment serverEnvironment;
    private final WebServer webServer;
    private final Host virtualHost;
    private final Bundle bundle;
    private final Map<HttpContext, ApplicationContext> contexts = new WeakHashMap<HttpContext, ApplicationContext>();

    HttpServiceImpl(ServerEnvironment serverEnvironment, WebServer webServer, Host virtualHost, Bundle bundle) {
        this.registry = HttpServiceFactory.GlobalRegistry.INSTANCE;
        this.virtualHost = virtualHost;
        this.webServer = webServer;
        this.serverEnvironment = serverEnvironment;
        this.bundle = bundle;
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.validateAlias(alias, false);
        this.validateServlet(servlet);
        Wrapper wrapper = this.registerInternal(alias, servlet, initparams, httpContext, HttpServiceFactory.Registration.Type.SERVLET);
        wrapper.allocate();
    }

    @Override
    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        this.validateAlias(alias, false);
        this.validateName(name);
        if (httpContext == null) {
            httpContext = this.createDefaultHttpContext();
        }
        ResourceServlet servlet = new ResourceServlet(name, httpContext);
        this.registerInternal(alias, (Servlet)servlet, null, null, HttpServiceFactory.Registration.Type.RESOURCE);
    }

    private synchronized Wrapper registerInternal(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext, HttpServiceFactory.Registration.Type type) throws NamespaceException {
        ShareableContext ctx;
        File storageDir = new File(this.serverEnvironment.getServerTempDir() + File.separator + alias + File.separator + "osgiservlet-root");
        storageDir.mkdirs();
        ApplicationContext actx = null;
        if (httpContext != null) {
            actx = this.contexts.get(httpContext);
            ctx = new ShareableContext(actx);
        } else {
            ctx = new ShareableContext(null);
            httpContext = new DefaultHttpContext(this.bundle);
        }
        ctx.setDocBase(storageDir.getPath());
        ctx.setPath(alias);
        ctx.addLifecycleListener((LifecycleListener)new ContextConfig());
        WebCtxLoader loader = new WebCtxLoader(servlet.getClass().getClassLoader());
        loader.setContainer((Container)this.virtualHost);
        ctx.setLoader((Loader)loader);
        ctx.addMimeMapping("html", "text/html");
        ctx.addMimeMapping("jpg", "image/jpeg");
        ctx.addMimeMapping("png", "image/png");
        ctx.addMimeMapping("gif", "image/gif");
        ctx.addMimeMapping("css", "text/css");
        ctx.addMimeMapping("js", "text/javascript");
        this.virtualHost.addChild((Container)ctx);
        WebLogger.WEB_LOGGER.registerWebapp(ctx.getName());
        try {
            ctx.create();
        }
        catch (Exception ex) {
            throw new NamespaceException(WebMessages.MESSAGES.createContextFailed(), ex);
        }
        try {
            ctx.start();
        }
        catch (LifecycleException ex) {
            throw new NamespaceException(WebMessages.MESSAGES.startContextFailed(), ex);
        }
        String wrapperName = alias.substring(1);
        Wrapper wrapper = ctx.createWrapper();
        wrapper.setName(wrapperName);
        wrapper.setServlet((Servlet)new SecurityServletWrapper(servlet, httpContext));
        wrapper.setServletClass(servlet.getClass().getName());
        if (initparams != null) {
            Enumeration keys = initparams.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String val = (String)initparams.get(key);
                wrapper.addInitParameter(key, val);
            }
        }
        this.registry.register(alias, this.bundle, ctx, servlet, type);
        String pattern = "/*";
        ctx.addChild((Container)wrapper);
        ctx.addServletMapping(pattern, wrapper.getName());
        Mapper mapper = this.webServer.getService().getMapper();
        mapper.addWrapper(this.virtualHost.getName(), ctx.getPath(), pattern, (Object)wrapper, false);
        if (httpContext != null && actx == null) {
            this.contexts.put(httpContext, ctx.getApplicationContext());
        }
        return wrapper;
    }

    @Override
    public void unregister(String alias) {
        try {
            this.validateAlias(alias, true);
        }
        catch (NamespaceException e) {
            WebLogger.WEB_LOGGER.errorf((Throwable)e, "", new Object[0]);
            return;
        }
        HttpServiceFactory.Registration reg = this.registry.unregister(alias, this.bundle);
        if (reg != null) {
            this.unregisterInternal(reg);
        }
    }

    @Override
    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }

    void unregisterInternal(HttpServiceFactory.Registration reg) {
        StandardContext context = reg.getContext();
        try {
            context.stop();
        }
        catch (LifecycleException e) {
            WebLogger.WEB_LOGGER.stopContextFailed((Throwable)e);
        }
        try {
            context.destroy();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.destroyContextFailed((Throwable)e);
        }
    }

    private void validateAlias(String alias, boolean exists) throws NamespaceException {
        if (alias == null || !alias.startsWith("/")) {
            throw new IllegalArgumentException(OSGiMessages.MESSAGES.invalidServletAlias(alias));
        }
        if (alias.length() > 1 && alias.endsWith("/")) {
            throw new IllegalArgumentException(OSGiMessages.MESSAGES.invalidServletAlias(alias));
        }
        if (exists && !this.registry.exists(alias)) {
            throw new IllegalArgumentException(OSGiMessages.MESSAGES.aliasMappingDoesNotExist(alias));
        }
        if (!exists && this.registry.exists(alias)) {
            throw new NamespaceException(OSGiMessages.MESSAGES.aliasMappingAlreadyExists(alias));
        }
    }

    private void validateName(String name) throws NamespaceException {
        if (name == null || name.length() > 1 && name.endsWith("/")) {
            throw new NamespaceException(OSGiMessages.MESSAGES.invalidResourceName(name));
        }
    }

    private void validateServlet(Servlet servlet) throws ServletException {
        if (this.registry.contains(servlet)) {
            throw new ServletException(OSGiMessages.MESSAGES.servletAlreadyRegistered(servlet.getServletInfo()));
        }
    }

    static class SecurityRequestWrapper
    extends HttpServletRequestWrapper
    implements HttpServletRequest {
        private final String remoteUser;
        private final String authType;

        SecurityRequestWrapper(String remoteUser, String authType, HttpServletRequest request) {
            super(request);
            this.remoteUser = remoteUser;
            this.authType = authType;
        }

        public String getAuthType() {
            return this.authType;
        }

        public String getRemoteUser() {
            return this.remoteUser;
        }
    }

    static class SecurityServletWrapper
    implements Servlet {
        private final HttpContext httpContext;
        private final Servlet delegate;

        SecurityServletWrapper(Servlet servlet, HttpContext ctx) {
            if (servlet == null) {
                throw new NullPointerException();
            }
            this.delegate = servlet;
            if (ctx == null) {
                throw new NullPointerException();
            }
            this.httpContext = ctx;
        }

        public void destroy() {
            this.delegate.destroy();
        }

        public ServletConfig getServletConfig() {
            return this.delegate.getServletConfig();
        }

        public String getServletInfo() {
            return this.delegate.getServletInfo();
        }

        public void init(ServletConfig sc) throws ServletException {
            this.delegate.init(sc);
        }

        public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                String authType;
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                if (!this.httpContext.handleSecurity(httpRequest, httpResponse)) {
                    return;
                }
                Object u = httpRequest.getAttribute("org.osgi.service.http.authentication.remote.user");
                String remoteUser = u instanceof String ? (String)u : null;
                Object a = httpRequest.getAttribute("org.osgi.service.http.authentication.type");
                String string = authType = a instanceof String ? (String)a : null;
                if (remoteUser != null || authType != null) {
                    request = new SecurityRequestWrapper(remoteUser, authType, httpRequest);
                }
            }
            this.delegate.service(request, response);
        }
    }

    static class ShareableContext
    extends StandardContext {
        ShareableContext(ApplicationContext existingContext) {
            this.context = existingContext;
        }

        ApplicationContext getApplicationContext() {
            if (this.context == null) {
                this.getServletContext();
            }
            return this.context;
        }
    }
}

