/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.counters;

import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.cxf.management.counters.Counter;
import org.apache.cxf.management.counters.MessageHandlingTimeRecorder;
import org.apache.cxf.management.counters.ResponseTimeCounterMBean;
import org.apache.cxf.message.FaultMode;

public class ResponseTimeCounter
implements ResponseTimeCounterMBean,
Counter {
    private ObjectName objectName;
    private AtomicInteger invocations = new AtomicInteger();
    private AtomicInteger checkedApplicationFaults = new AtomicInteger();
    private AtomicInteger unCheckedApplicationFaults = new AtomicInteger();
    private AtomicInteger runtimeFaults = new AtomicInteger();
    private AtomicInteger logicalRuntimeFaults = new AtomicInteger();
    private long totalHandlingTime;
    private long maxHandlingTime;
    private long minHandlingTime = Integer.MAX_VALUE;

    public ResponseTimeCounter(ObjectName on) {
        this.objectName = on;
    }

    @Override
    public void increase(MessageHandlingTimeRecorder mhtr) {
        this.invocations.getAndIncrement();
        FaultMode faultMode = mhtr.getFaultMode();
        if (null != faultMode) {
            switch (faultMode) {
                case CHECKED_APPLICATION_FAULT: {
                    this.checkedApplicationFaults.incrementAndGet();
                    break;
                }
                case LOGICAL_RUNTIME_FAULT: {
                    this.logicalRuntimeFaults.incrementAndGet();
                    break;
                }
                case RUNTIME_FAULT: {
                    this.runtimeFaults.incrementAndGet();
                    break;
                }
                case UNCHECKED_APPLICATION_FAULT: {
                    this.unCheckedApplicationFaults.incrementAndGet();
                    break;
                }
                default: {
                    this.runtimeFaults.incrementAndGet();
                }
            }
        }
        long handlingTime = 0L;
        if (mhtr.isOneWay()) {
            if (mhtr.getEndTime() > 0L) {
                handlingTime = mhtr.getHandlingTime();
            }
        } else {
            handlingTime = mhtr.getHandlingTime();
        }
        this.totalHandlingTime += handlingTime;
        if (this.maxHandlingTime < handlingTime) {
            this.maxHandlingTime = handlingTime;
        }
        if (this.minHandlingTime > handlingTime) {
            this.minHandlingTime = handlingTime;
        }
    }

    @Override
    public void reset() {
        this.invocations.set(0);
        this.checkedApplicationFaults.set(0);
        this.unCheckedApplicationFaults.set(0);
        this.runtimeFaults.set(0);
        this.logicalRuntimeFaults.set(0);
        this.totalHandlingTime = 0L;
        this.maxHandlingTime = 0L;
        this.minHandlingTime = Integer.MAX_VALUE;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Number getAvgResponseTime() {
        return (int)(this.totalHandlingTime / (long)this.invocations.get());
    }

    @Override
    public Number getMaxResponseTime() {
        return this.maxHandlingTime;
    }

    @Override
    public Number getMinResponseTime() {
        return this.minHandlingTime;
    }

    @Override
    public Number getNumInvocations() {
        return this.invocations.get();
    }

    @Override
    public Number getNumCheckedApplicationFaults() {
        return this.checkedApplicationFaults.get();
    }

    @Override
    public Number getNumLogicalRuntimeFaults() {
        return this.logicalRuntimeFaults.get();
    }

    @Override
    public Number getNumRuntimeFaults() {
        return this.runtimeFaults.get();
    }

    @Override
    public Number getNumUnCheckedApplicationFaults() {
        return this.unCheckedApplicationFaults.get();
    }

    @Override
    public Number getTotalHandlingTime() {
        return this.totalHandlingTime;
    }
}

