/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.NetworkMessages;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.OutboundSocketBindingService;

public class RemoteDestinationOutboundSocketBindingService
extends OutboundSocketBindingService {
    private final String destinationHost;
    private final int destinationPort;

    public RemoteDestinationOutboundSocketBindingService(String name, String destinationAddress, int destinationPort, Integer sourcePort, boolean fixedSourcePort) {
        super(name, sourcePort, fixedSourcePort);
        if (destinationAddress == null || destinationAddress.trim().isEmpty()) {
            throw NetworkMessages.MESSAGES.nullDestinationAddress(name);
        }
        if (destinationPort < 0) {
            throw NetworkMessages.MESSAGES.negativeDestinationPort(destinationPort, name);
        }
        this.destinationHost = destinationAddress;
        this.destinationPort = destinationPort;
    }

    @Override
    protected OutboundSocketBinding createOutboundSocketBinding() {
        return new OutboundSocketBinding(this.outboundSocketName, (SocketBindingManager)this.socketBindingManagerInjectedValue.getValue(), this.destinationHost, this.destinationPort, (NetworkInterfaceBinding)this.sourceInterfaceInjectedValue.getOptionalValue(), this.sourcePort, this.fixedSourcePort);
    }
}

