/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.AbstractTree;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Scalar;
import com.tandbergtv.workflow.message.util.Tree;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Unmarshaller {
    public static WorkflowMessage unmarshal(Document document) throws MarshalException {
        WorkflowMessage message = null;
        try {
            Element root = document.getDocumentElement();
            String uid = root.getAttribute("UID");
            String type = root.getAttribute("Type");
            String key = root.getAttribute("RequestKey");
            message = Unmarshaller.createWorkflowMessage(uid, type, key);
            Unmarshaller.unmarshalCommand(document, message);
            Unmarshaller.unmarshalProperties(document, message);
            Unmarshaller.unmarshalMultiLevelParameters(document, message);
        }
        catch (Exception e) {
            throw new MarshalException("Failed to unmarshal the document", e);
        }
        return message;
    }

    private static void unmarshalMultiLevelParameters(Document document, WorkflowMessage message) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element parameterList = (Element)xpath.evaluate("//MessageBody/ParameterList", document, XPathConstants.NODE);
        if (parameterList != null && parameterList.getChildNodes().getLength() > 0) {
            WorkflowPayload payload = message.getPayload();
            AbstractTree tree = payload.getPayload();
            NodeList parameters = parameterList.getChildNodes();
            for (int i = 0; i < parameters.getLength(); ++i) {
                Node node = parameters.item(i);
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                String tag = e.getTagName();
                if (tag.equals("Parameter")) {
                    Unmarshaller.unmarshallScalar(e, (Tree)tree);
                    continue;
                }
                if (!tag.equals("List")) continue;
                Unmarshaller.unmarshallTree(e, (Tree)tree);
            }
        }
    }

    private static void unmarshallTree(Element element, Tree tree) {
        String elementKey = element.getAttribute("Name");
        Tree absTree = new Tree(elementKey);
        tree.add(absTree);
        NodeList listItems = element.getChildNodes();
        for (int i = 0; i < listItems.getLength(); ++i) {
            Node node = listItems.item(i);
            if (!(node instanceof Element)) continue;
            Element listItem = (Element)node;
            String tag = listItem.getTagName();
            if (tag.equals("Parameter")) {
                Unmarshaller.unmarshallScalar(listItem, absTree);
                continue;
            }
            if (!tag.equals("ListItem")) continue;
            String listItemKey = listItem.getAttribute("Name");
            Tree listItemTree = new Tree(listItemKey);
            ((AbstractTree)absTree).add(listItemTree);
            NodeList listItemParams = listItem.getChildNodes();
            for (int j = 0; j < listItemParams.getLength(); ++j) {
                Node paramNode = listItemParams.item(j);
                if (!(paramNode instanceof Element)) continue;
                Element parameter = (Element)paramNode;
                String paramTag = parameter.getTagName();
                if (paramTag.equals("Parameter")) {
                    Unmarshaller.unmarshallScalar(parameter, listItemTree);
                    continue;
                }
                if (!paramTag.equals("List")) continue;
                Unmarshaller.unmarshallTree(parameter, listItemTree);
            }
        }
    }

    private static void unmarshallScalar(Element parameter, Tree tree) {
        String parameterKey = parameter.getAttribute("Name");
        Element value = (Element)parameter.getElementsByTagName("Value").item(0);
        String parameterValue = value.getTextContent();
        Tree scalar = new Tree(parameterKey);
        ((AbstractTree)scalar).add(new Scalar(parameterValue));
        tree.add(scalar);
    }

    private static void unmarshalProperties(Document document, WorkflowMessage message) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element e = (Element)xpath.evaluate("//WFSMessage/Source", document, XPathConstants.NODE);
        if (e != null && e.hasChildNodes()) {
            String name = e.getAttribute("Name");
            Element deviceElement = (Element)e.getFirstChild();
            ISource source = (ISource)Unmarshaller.createDevice(name, deviceElement);
            message.setSource(source);
        }
        if ((e = (Element)xpath.evaluate("//WFSMessage/ResponseDestination", document, XPathConstants.NODE)) != null && e.hasChildNodes()) {
            Element deviceElement = (Element)e.getFirstChild();
            IDestination responseDestination = (IDestination)Unmarshaller.createDevice(null, deviceElement);
            message.setResponseDestination(responseDestination);
        }
    }

    private static IDevice createDevice(String name, Element deviceElement) {
        ISource device = null;
        if (deviceElement.getTagName() == "URL") {
            String url = deviceElement.getTextContent();
            device = new HTTPDevice(url, name);
        } else if (deviceElement.getTagName() == "Host") {
            String ip = deviceElement.getAttributes().getNamedItem("IP").getTextContent();
            String portString = deviceElement.getAttributes().getNamedItem("Port").getTextContent();
            int port = portString == null ? 0 : Integer.parseInt(portString);
            device = new TCPDevice(ip, port);
        }
        return device;
    }

    private static WorkflowMessage createWorkflowMessage(String uid, String type, String key) {
        MessageUIDImpl messageUID = new MessageUIDImpl(uid);
        MessageKeyImpl messageKey = new MessageKeyImpl(key);
        WorkflowMessage.MessageType messageType = WorkflowMessage.MessageType.valueOf(type);
        return new WorkflowMessage(messageUID, messageKey, messageType);
    }

    private static void unmarshalCommand(Document document, WorkflowMessage message) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element e = (Element)xpath.evaluate("//Command", document, XPathConstants.NODE);
        if (e == null) {
            return;
        }
        WPCLCommand command = new WPCLCommand(e.getAttribute("Name"));
        for (int i = 0; i < e.getChildNodes().getLength(); ++i) {
            Node node = e.getChildNodes().item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String name = child.getAttribute("Name");
            String value = child.getAttribute("Value");
            command.addParameter(name, value);
        }
        message.setCommand(command);
    }
}

