/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DeviceTypeUtil {
    private static final Logger logger = Logger.getLogger(DeviceTypeUtil.class);

    public static IDevice createDevice(Resource resource) {
        ISource device = null;
        ResourceConnectionType rct = resource.getResourceType().getConnectionType();
        logger.debug((Object)("Creating device for resource " + resource.getName()));
        if (rct == ResourceConnectionType.URL) {
            device = new HTTPDevice(resource.getConnectionString(), resource.getName());
        } else if (rct == ResourceConnectionType.IP_PORT) {
            StringTokenizer st = new StringTokenizer(resource.getConnectionString(), ":");
            if (st.hasMoreTokens()) {
                String ipAddress = st.nextToken();
                device = new TCPDevice(ipAddress, resource.getName());
            }
            if (st.hasMoreTokens()) {
                String portNumberString = st.nextToken();
                int portNumber = Integer.parseInt(portNumberString);
                ((TCPDevice)device).setPort(portNumber);
            }
        }
        return device;
    }

    public static IDevice createDevice(String connectionType, String connectionString) {
        ISource device = null;
        logger.debug((Object)("Creating device for connectionType: " + connectionType + " connectionString: " + connectionString));
        if (connectionType.equals(ResourceConnectionType.URL.getDisplayName())) {
            device = new HTTPDevice(connectionString);
        } else if (connectionType.equals(ResourceConnectionType.IP_PORT.getDisplayName())) {
            StringTokenizer st = new StringTokenizer(connectionString, ":");
            if (st.hasMoreTokens()) {
                String ipAddress = st.nextToken();
                device = new TCPDevice(ipAddress);
            }
            if (st.hasMoreTokens()) {
                String portNumberString = st.nextToken();
                int portNumber = Integer.parseInt(portNumberString);
                ((TCPDevice)device).setPort(portNumber);
            }
        }
        return device;
    }

    public static IDevice createDevice(String connectionType, String connectionString, String connectionOrigin) {
        ISource device = null;
        logger.debug((Object)("Creating device for connectionType: " + connectionType + " connectionString: " + connectionString));
        if (connectionType.equals(ResourceConnectionType.URL.getDisplayName())) {
            device = new HTTPDevice(connectionString, connectionOrigin);
        } else if (connectionType.equals(ResourceConnectionType.IP_PORT.getDisplayName())) {
            StringTokenizer st = new StringTokenizer(connectionString, ":");
            if (st.hasMoreTokens()) {
                String ipAddress = st.nextToken();
                device = new TCPDevice(ipAddress, connectionOrigin);
            }
            if (st.hasMoreTokens()) {
                String portNumberString = st.nextToken();
                int portNumber = Integer.parseInt(portNumberString);
                ((TCPDevice)device).setPort(portNumber);
            }
        }
        return device;
    }

    public static String getConnectionString(IDevice device) {
        String result = null;
        if (device instanceof HTTPDevice) {
            HTTPDevice httpDevice = (HTTPDevice)device;
            result = httpDevice.getUrl();
        } else if (device instanceof TCPDevice) {
            TCPDevice tcpDevice = (TCPDevice)device;
            result = tcpDevice.getIP() + ":" + tcpDevice.getPort();
        }
        return result;
    }

    public static IDevice createWorkflowDevice() {
        IDevice device;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            String connectionType = properties.getProperty("Source.ConnectionType");
            String connectionString = properties.getProperty("Source.ConnectionString");
            String connectionOrigin = properties.getProperty("Source.Name");
            device = DeviceTypeUtil.createDevice(connectionType, connectionString, connectionOrigin);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create workflow device", e);
        }
        return device;
    }
}

