/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui;

import guitools.toolkit.JDebug;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.cs.CustomTaskEditor;
import jet.cs.CustomTaskManager;
import jet.cs.ReportListIntf;
import jet.cs.Schedule;
import jet.cs.ui.CSGuiUtil;
import jet.cs.ui.JRTaskEditor;
import jet.cs.ui.OneTimePanel;
import jet.cs.ui.RepeatlyPanel;

public class SchedulePanel
extends JPanel
implements ItemListener {
    static int QOIV = 500;
    static int WARNING = 364;
    JComboBox add = new JComboBox();
    private static final String addItem = JCliResource.getMessage((String)"CS_MSG_41");
    ButtonGroup addItemListener = new ButtonGroup();
    JRadioButton I = new JRadioButton(addItem, false);
    JRadioButton append = new JRadioButton(JCliResource.getMessage((String)"CS_MSG_40"), true);
    JRadioButton changed = new JRadioButton(JCliResource.getMessage((String)"CS_MSG_47"), false);
    private JLabel clone = new JLabel(JCliResource.getMessage((String)"CS_MSG_48") + ": ", 4);
    private JComboBox compareTo = new JComboBox();
    private OneTimePanel get = null;
    private RepeatlyPanel getAvailableIDs = null;
    private JCheckBox getBoolean = new JCheckBox("Run missed task upon Server restart.");
    Hashtable getDefaultTimeZone = null;
    String getDisplayName = CSUtil.getDefaultTimeZone();
    private ReportListIntf getDisplayNames = null;
    String getGC = null;
    boolean getID = false;
    String getMessage = null;
    CustomTaskEditor getNextTime = null;
    Hashtable getSchedule = new Hashtable();
    private boolean getSelectedItem = false;
    private boolean getSource = false;
    public String strCatalog = null;
    public String strRpt = null;

    public SchedulePanel(Properties properties, ReportListIntf reportListIntf, String string) {
        this(properties, reportListIntf, string, false);
    }

    public SchedulePanel(Properties properties, ReportListIntf reportListIntf, String string, boolean bl) {
        this.getDefaultTimeZone = properties;
        if (string != null) {
            this.getDisplayName = string;
        }
        this.getSource = bl;
        if (properties != null) {
            this.getGC = (String)properties.get("jrs.task_class");
            if (this.getGC != null) {
                this.getID = CSUtil.getBoolean((String)((String)properties.get("jrs.has_task_listener")), (boolean)false);
                if (this.getID) {
                    this.getMessage = (String)properties.get("jrs.task_listener_class");
                }
                this.getSchedule.put(this.getGC, properties.clone());
            }
        }
        this.getDisplayNames = reportListIntf;
        this.init();
    }

    public void init() {
        int n;
        String[] stringArray;
        this.setLayout(null);
        boolean bl = false;
        this.getBoolean.setVisible(false);
        if (this.getDefaultTimeZone != null && this.getDefaultTimeZone.get("jrs.launch_type") != null) {
            Object object;
            stringArray = (String[])this.getDefaultTimeZone.get("jrs.timezone");
            if (stringArray != null && stringArray.trim().length() >= 0) {
                this.getDisplayName = stringArray;
            }
            n = CSUtil.parseInt((String)((String)this.getDefaultTimeZone.get("jrs.launch_type")), (int)0);
            boolean bl2 = CSUtil.getBoolean((String)((String)this.getDefaultTimeZone.get("jrs.rerun_missed_task")), (boolean)false);
            this.getBoolean.setVisible(n != 0);
            this.getBoolean.setSelected(bl2);
            if (n != 8) {
                object = null;
                this.append.setSelected(true);
                if (n == 1) {
                    object = this.getDisplayName == null ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(this.getDisplayName));
                    ((Calendar)object).set(CSUtil.parseInt((String)((String)this.getDefaultTimeZone.get("jrs.exe_year"))), CSUtil.parseInt((String)((String)this.getDefaultTimeZone.get("jrs.exe_month"))) - 1, CSUtil.parseInt((String)((String)this.getDefaultTimeZone.get("jrs.exe_day"))), CSUtil.parseInt((String)((String)this.getDefaultTimeZone.get("jrs.exe_hour"))), CSUtil.parseInt((String)((String)this.getDefaultTimeZone.get("jrs.exe_min"))), 0);
                    this.I.setSelected(true);
                }
                this.get = new OneTimePanel((GregorianCalendar)object, this.getDisplayName, this);
                this.getAvailableIDs = new RepeatlyPanel(null, this.getDisplayName);
            } else {
                this.changed.setSelected(true);
                object = new Schedule(this.getDisplayName);
                ((Schedule)object).setSchedule(this.getDefaultTimeZone);
                this.getAvailableIDs = new RepeatlyPanel((Schedule)object, this.getDisplayName);
                this.get = new OneTimePanel(null, this.getDisplayName, this);
                bl = true;
            }
        } else {
            this.get = new OneTimePanel(null, this.getDisplayName, this);
            this.getAvailableIDs = new RepeatlyPanel(null, this.getDisplayName);
        }
        try {
            CSGuiUtil.loadToComboBox(CustomTaskManager.getDisplayNames(), this.add);
            if (this.getSource) {
                this.add.removeItem("Value-based Trigger");
            }
        }
        catch (Exception exception) {
            JDebug.WARNING((Throwable)exception);
        }
        if (this.getGC != null) {
            try {
                stringArray = CustomTaskManager.getDisplayName((String)this.getGC);
                if (stringArray != null) {
                    this.add.setSelectedItem(stringArray);
                }
            }
            catch (Exception exception) {
                JDebug.WARNING((Throwable)exception);
            }
        } else {
            try {
                stringArray = CustomTaskManager.getDisplayName((String)"jet.server.schedule.jrtasks.PublishRptTask");
                if (stringArray != null) {
                    this.add.setSelectedItem(stringArray);
                }
            }
            catch (Exception exception) {
                JDebug.WARNING((Throwable)exception);
            }
        }
        stringArray = TimeZone.getAvailableIDs();
        n = 0;
        while (n < stringArray.length) {
            this.compareTo.addItem(stringArray[n]);
            ++n;
        }
        this.compareTo.addItem(this.getDisplayName);
        this.compareTo.setSelectedItem(this.getDisplayName);
        this.setBounds(0, 0, QOIV, WARNING);
        Dimension dimension = this.getSize();
        int n2 = 0;
        int n3 = 10;
        int n4 = 24;
        int n5 = 150;
        int n6 = 120;
        int n7 = dimension.height - n3 - 55;
        this.changed.setBounds(n2 + 20, n3 + 2 * n4, 240, n4);
        this.I.setBounds(n2 + 20, n3 + n4, 400, n4);
        this.append.setBounds(n2 + 20, n3, 240, n4);
        this.compareTo.setBounds(dimension.width - n5 - 25, n3, n5, n4);
        this.clone.setBounds(dimension.width - n5 - 25 - n6, n3, n6, n4);
        n3 = n3 + 2 * n4 + 30;
        this.getAvailableIDs.setBounds(n2, n3, dimension.width, n7);
        this.get.setBounds(n2, n3, dimension.width, n7);
        this.getBoolean.setBounds(n2 + 20, n3 + n7 + 5, 400, 20);
        this.add(this.changed);
        this.add(this.I);
        this.add(this.append);
        this.addItemListener.add(this.I);
        this.addItemListener.add(this.append);
        this.addItemListener.add(this.changed);
        this.I.addItemListener(this);
        this.append.addItemListener(this);
        this.add(this.compareTo);
        this.add(this.clone);
        this.add(this.get);
        this.add(this.getAvailableIDs);
        this.add(this.getBoolean);
        this.changed.setSelected(bl);
        this.showPage();
        this.changed.addItemListener(this);
        this.add.addItemListener(this);
        this.compareTo.addItemListener(this);
        if (this.getSource) {
            this.changed.setEnabled(false);
            this.compareTo.setEnabled(false);
            this.clone.setEnabled(false);
            this.get.setEnabled(false);
            this.getAvailableIDs.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.getBoolean.setVisible(!this.append.isSelected());
        if (object == this.changed) {
            this.showPage();
        } else if (object == this.append) {
            this.get.setVisible(false);
            this.getAvailableIDs.setVisible(false);
            this.I.setText(addItem);
        } else if (object == this.I) {
            this.get.setVisible(true);
            this.getAvailableIDs.setVisible(false);
            this.get.changed(this);
        } else if (object == this.compareTo) {
            this.getDisplayName = (String)this.compareTo.getSelectedItem();
            this.get.setTimeZone(this.getDisplayName);
            this.getAvailableIDs.setTimeZone(this.getDisplayName);
        }
    }

    public void showPage() {
        if (this.changed.isSelected()) {
            this.get.setVisible(false);
            this.getAvailableIDs.setVisible(true);
        } else if (this.append.isSelected()) {
            this.getAvailableIDs.setVisible(false);
            this.get.setVisible(false);
        } else {
            this.getAvailableIDs.setVisible(false);
            this.get.setVisible(true);
        }
        this.I.setText(addItem);
    }

    public boolean isRepeatly() {
        return this.changed.isSelected();
    }

    public boolean isInstantLaunch() {
        return this.append.isSelected();
    }

    public GregorianCalendar getGC() {
        if (this.isRepeatly()) {
            return null;
        }
        return this.isInstantLaunch() ? null : this.get.getGC();
    }

    public Schedule getSchedule() {
        if (this.isRepeatly()) {
            return this.getAvailableIDs.getSchedule();
        }
        return null;
    }

    public boolean isJRTaskEditor() {
        if (this.getNextTime != null) {
            return this.getNextTime instanceof JRTaskEditor;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties toProperties(Properties properties) throws Exception {
        Properties properties2 = properties;
        if (!this.isInstantLaunch()) {
            properties2.remove("jrs.rerun_missed_task");
            if (this.getBoolean.isSelected()) {
                properties2.put("jrs.rerun_missed_task", String.valueOf(true));
            }
        }
        if (this.isRepeatly()) {
            properties2.put("jrs.launch_type", String.valueOf(8));
            if (this.getSchedule().getNextTime() == null) throw new Exception(JCliResource.getMessage((String)"CS_ERR_71"));
            this.getSchedule().toProperties(properties2);
            return properties2;
        } else if (this.isInstantLaunch()) {
            properties2.put("jrs.launch_type", String.valueOf(0));
            return properties2;
        } else {
            properties2.put("jrs.launch_type", String.valueOf(1));
            GregorianCalendar gregorianCalendar = this.getGC();
            Date date = new Date();
            date.setSeconds(0);
            if (date.compareTo(gregorianCalendar.getTime()) >= 0) {
                JOptionPane.showMessageDialog(this, "Time expired!", "Error", 0);
                return null;
            }
            properties2.put("jrs.exe_year", String.valueOf(gregorianCalendar.get(1)));
            properties2.put("jrs.exe_month", String.valueOf(gregorianCalendar.get(2) + 1));
            properties2.put("jrs.exe_day", String.valueOf(gregorianCalendar.get(5)));
            properties2.put("jrs.exe_hour", String.valueOf(gregorianCalendar.get(11)));
            properties2.put("jrs.exe_min", String.valueOf(gregorianCalendar.get(12)));
            properties2.put("jrs.timezone", gregorianCalendar.getTimeZone().getID());
        }
        return properties2;
    }

    public void afterShow() {
        if (this.getSource) {
            this.changed.setEnabled(false);
            this.compareTo.setEnabled(false);
            this.clone.setEnabled(false);
            this.get.setEnabled(false);
            this.getAvailableIDs.setEnabled(false);
        }
    }

    public void addTaskTypeItemListener(ItemListener itemListener) {
        this.add.addItemListener(itemListener);
    }

    public boolean isTaskTypeComponent(Object object) {
        return object == this.add;
    }

    public Object getSelectedTaskTypeItem() {
        return this.add.getSelectedItem();
    }
}

