/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartPropertyValues;
import chart.ChartRenderInfo;
import chart.data.ChartDataSetInfo;
import chart.data.ChartTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ChartDefinition {
    public static String Magic = "ChartDefinition";
    public static int version = 256;
    private String QOIV;
    private String add;
    private Map addAll;
    private Map addType;
    private List append;
    private int booleanValue = 0;
    private int canRelyAxisY2 = 0;
    private static final String containsKey = "\\^" + Integer.toHexString(44);
    private static final String createPrimaryLayer = "^" + Integer.toHexString(0);
    private boolean createSecondLayer;
    private boolean equals;

    public ChartDefinition() {
        this(null, null);
    }

    public ChartDefinition(String string, String string2) {
        this.QOIV = string;
        this.add = string2;
        this.addAll = new HashMap();
        this.addType = new HashMap();
        this.append = new ArrayList();
    }

    public void addType(String string, boolean bl, int n) {
        if (bl) {
            if (this.addType.containsKey(string)) {
                throw new IllegalArgumentException("The Chart type has been existed in secondary axis!");
            }
        } else if (this.addAll.containsKey(string)) {
            throw new IllegalArgumentException("The Chart type has been existed in primary axis!");
        }
        this.QOIV();
        int n2 = ChartPropertyValues.mapTypeFromStrToInt(string);
        if (bl) {
            this.canRelyAxisY2(n2);
        }
        this.Magic(string, bl);
        if (n == -1) {
            this.append.add(string);
        } else {
            this.append.add(n, string);
        }
        if (bl) {
            this.addType.put(string, null);
        } else {
            this.addAll.put(string, null);
        }
    }

    public void addType(String string, boolean bl) {
        this.addType(string, bl, -1);
    }

    public void addType(String string, List list, boolean bl) {
        this.addType(string, list, bl, -1);
    }

    public void addType(String string, List list, boolean bl, int n) {
        List list2;
        if (bl) {
            if (this.addType.containsKey(string)) {
                list2 = (List)this.addType.get(string);
                list2.addAll(list);
            }
        } else if (this.addAll.containsKey(string)) {
            list2 = (List)this.addAll.get(string);
            list2.addAll(list);
        }
        this.QOIV();
        int n2 = ChartPropertyValues.mapTypeFromStrToInt(string);
        this.add(n2, list);
        if (bl) {
            this.canRelyAxisY2(n2);
        }
        this.addAll(n2, bl);
        if (n == -1) {
            this.append.add(string);
        } else {
            this.append.add(n, string);
        }
        if (bl) {
            this.addType.put(string, list);
        } else {
            this.addAll.put(string, list);
        }
    }

    public void changeType(String string, String string2, boolean bl) {
        int n;
        List list = null;
        list = bl ? (List)this.addType.get(string) : (List)this.addAll.get(string);
        if (this.append.size() >= 2) {
            this.Magic(string2, bl);
        }
        if (list != null && list.size() > 0) {
            n = list.size();
            int n2 = ChartPropertyValues.mapTypeFromStrToInt(string2);
            this.add(n2, list);
        }
        n = -1;
        n = bl ? this.append.lastIndexOf(string) : this.append.indexOf(string);
        this.removeType(string, bl);
        if (list == null || list.size() == 0) {
            this.addType(string2, bl, n);
        } else {
            this.addType(string2, list, bl, n);
        }
    }

    private void Magic(String string, boolean bl) {
        int n = ChartPropertyValues.mapTypeFromStrToInt(string);
        if (bl) {
            if (this.addType.size() == 1) {
                this.canRelyAxisY2 = 0;
            }
        } else if (this.addAll.size() == 1) {
            this.booleanValue = 0;
        }
        this.addAll(n, bl);
    }

    public void removeType(String string, boolean bl) {
        int n = -1;
        if (bl) {
            n = this.append.lastIndexOf(string);
            this.addType.remove(string);
            if (this.addType.size() == 0) {
                this.canRelyAxisY2 = 0;
            }
        } else {
            n = this.append.indexOf(string);
            this.addAll.remove(string);
            if (this.addAll.size() == 0) {
                this.booleanValue = 0;
            }
        }
        if (n != -1) {
            this.append.remove(n);
        }
    }

    private void QOIV() {
        boolean bl;
        if (this.append.size() <= 0) {
            return;
        }
        String string = (String)this.append.get(0);
        int n = ChartPropertyValues.mapTypeFromStrToInt(string);
        int n2 = ChartTypeInfo.getEffect(n);
        int n3 = ChartTypeInfo.getPrimType(n);
        boolean bl2 = bl = n2 == 0 && (n3 == 0 || n3 == 1 || n3 == 2 || n3 == 3 || n3 == 10 || n3 == 8 || n3 == 9);
        if (!bl) {
            throw new IllegalArgumentException("The previous type can not be comb chart!");
        }
    }

    public void canRelyAxisY2(int n) {
        boolean bl;
        int n2 = ChartTypeInfo.getEffect(n);
        int n3 = ChartTypeInfo.getPrimType(n);
        boolean bl2 = bl = n2 == 0 && (n3 == 0 || n3 == 1 || n3 == 2 || n3 == 3 || n3 == 8 || n3 == 9 || n3 == 10);
        if (!bl) {
            throw new IllegalArgumentException("can not set current dataset to Y2 axis.");
        }
    }

    public void changeDatasetOrder(String string, List list, boolean bl) {
        if (bl) {
            this.addType.put(string, list);
        } else {
            this.addAll.put(string, list);
        }
    }

    public void addValuesToExistType(String string, List list, boolean bl) {
        int n = ChartPropertyValues.mapTypeFromStrToInt(string);
        this.add(n, list);
        if (bl) {
            this.addType.put(string, list);
        } else {
            this.addAll.put(string, list);
        }
    }

    private void add(int n, List list) {
        int n2 = ChartTypeInfo.getEffect(n);
        int n3 = ChartTypeInfo.getPrimType(n);
        int n4 = list.size();
        boolean bl = false;
        String string = null;
        if (n2 == 4096) {
            if (n4 == 1) {
                bl = true;
            } else {
                string = "You must choose only 1 value for current effect 3d type.";
            }
        } else {
            switch (n3) {
                case 8: {
                    if (n4 >= 1) {
                        bl = true;
                        break;
                    }
                    string = "You must chose 1 value at least for current type.";
                    break;
                }
                case 9: {
                    if (n4 >= 2) {
                        bl = true;
                        break;
                    }
                    string = "You must chose 2 values at least for current type";
                    break;
                }
                case 10: {
                    if (this.add != null) {
                        string = "You can not add series group for current type";
                        break;
                    }
                    int n5 = ChartTypeInfo.getSubType(n);
                    switch (n5) {
                        case 512: {
                            if (n4 == 2) {
                                bl = true;
                                break;
                            }
                            string = "You must chose only 2 values for current type";
                            break;
                        }
                        case 256: {
                            if (n4 == 3) {
                                bl = true;
                                break;
                            }
                            string = "You must chose only 3 values for current type";
                            break;
                        }
                        case 0: {
                            if (n4 == 4) {
                                bl = true;
                                break;
                            }
                            string = "You must chose only 4 values for current type";
                        }
                    }
                    break;
                }
                default: {
                    if (n4 >= 0) {
                        bl = true;
                        break;
                    }
                    string = "You must chose 1 value at least for current type";
                }
            }
        }
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    private void addAll(int n, boolean bl) throws IllegalArgumentException {
        int n2 = this.addType(n);
        boolean bl2 = false;
        switch (n2) {
            case 1: {
                if (this.booleanValue == 3 || this.canRelyAxisY2 == 3) {
                    bl2 = false;
                    break;
                }
                if (bl) {
                    if (this.canRelyAxisY2 != 0 && this.canRelyAxisY2 != 1) break;
                    this.canRelyAxisY2 = 1;
                    bl2 = true;
                    break;
                }
                if (this.booleanValue != 0 && this.booleanValue != 1) break;
                this.booleanValue = 1;
                bl2 = true;
                break;
            }
            case 2: {
                if (this.booleanValue == 3 || this.canRelyAxisY2 == 3) {
                    bl2 = false;
                    break;
                }
                if (bl) {
                    if (this.canRelyAxisY2 != 0 && this.canRelyAxisY2 != 2) break;
                    this.canRelyAxisY2 = 2;
                    bl2 = true;
                    break;
                }
                if (this.booleanValue == 0 || this.booleanValue == 2) {
                    this.booleanValue = 2;
                    bl2 = true;
                }
                if (this.booleanValue != 1 && this.booleanValue != 2) break;
                bl2 = true;
                break;
            }
            case 3: {
                if (this.booleanValue != 0 && this.booleanValue != 3 || this.canRelyAxisY2 != 0 && this.canRelyAxisY2 != 3) break;
                if (bl) {
                    this.canRelyAxisY2 = 3;
                } else {
                    this.booleanValue = 3;
                }
                bl2 = true;
                break;
            }
            case 4: {
                if (this.booleanValue != 0) {
                    bl2 = false;
                    break;
                }
                this.booleanValue = 4;
                this.canRelyAxisY2 = 0;
                bl2 = true;
                break;
            }
            case 6: {
                if (this.booleanValue != 0) {
                    bl2 = false;
                    break;
                }
                this.booleanValue = 6;
                this.canRelyAxisY2 = 0;
                bl2 = true;
                break;
            }
            case 5: {
                if (this.booleanValue != 0) {
                    bl2 = false;
                    break;
                }
                this.booleanValue = 5;
                this.canRelyAxisY2 = 0;
                bl2 = true;
                break;
            }
            case 257: {
                if (this.booleanValue != 0) {
                    bl2 = false;
                    break;
                }
                this.booleanValue = 257;
                this.canRelyAxisY2 = 0;
                bl2 = true;
                break;
            }
            case 258: {
                if (this.booleanValue != 0) {
                    bl2 = false;
                    break;
                }
                this.booleanValue = 258;
                this.canRelyAxisY2 = 0;
                bl2 = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type, please check!");
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("incompatible coordinate for this type.");
        }
    }

    private int addType(int n) {
        int n2 = 0;
        int n3 = ChartTypeInfo.getEffect(n);
        int n4 = ChartTypeInfo.getPrimType(n);
        switch (n4) {
            case 4: {
                n2 = 5;
                break;
            }
            case 6: {
                n2 = 6;
                break;
            }
            case 5: {
                n2 = 4;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: {
                n2 = 3;
            }
        }
        if (n3 == 4096) {
            n2 |= 0x100;
        }
        return n2;
    }

    public void getCoordinateInfo(ChartRenderInfo chartRenderInfo) {
        if (this.booleanValue != 0) {
            chartRenderInfo.createPrimaryLayer();
            this.append(chartRenderInfo.primLayer, this.booleanValue);
            chartRenderInfo.is3DEffect = this.is3DEffect();
        }
        if (this.canRelyAxisY2 != 0) {
            chartRenderInfo.createSecondLayer();
            this.append(chartRenderInfo.secLayer, this.canRelyAxisY2);
        }
    }

    private void append(ChartRenderInfo.ChartLayerRenderInfo chartLayerRenderInfo, int n) {
        switch (n) {
            case 1: 
            case 257: {
                chartLayerRenderInfo.I(1);
                chartLayerRenderInfo.I(true);
                break;
            }
            case 2: 
            case 258: {
                chartLayerRenderInfo.I(2);
                chartLayerRenderInfo.I(true);
                break;
            }
            case 3: {
                chartLayerRenderInfo.I(3);
                chartLayerRenderInfo.I(true);
                break;
            }
            case 4: {
                chartLayerRenderInfo.I(4);
                break;
            }
            case 6: {
                chartLayerRenderInfo.I(5);
                break;
            }
            case 5: {
                chartLayerRenderInfo.I(0);
            }
        }
    }

    public boolean is3DEffect() {
        return (this.booleanValue & 0x100) > 0;
    }

    public ChartDataSetInfo[] getChartDataSetInfos() {
        ChartDataSetInfo[] chartDataSetInfoArray = new ChartDataSetInfo[this.append.size()];
        int n = 0;
        while (n < this.append.size()) {
            String string = (String)this.append.get(n);
            chartDataSetInfoArray[n] = new ChartDataSetInfo(ChartPropertyValues.mapTypeFromStrToInt(string));
            if (n >= this.addAll.size()) {
                chartDataSetInfoArray[n].setAxisInfo(1);
            }
            ++n;
        }
        return chartDataSetInfoArray;
    }

    public List getChartDatasetSequence() {
        return this.append;
    }

    public String[] getIndexedValueNames() {
        ArrayList arrayList = new ArrayList();
        int n = this.append.size();
        int n2 = this.addAll.size();
        int n3 = 0;
        while (n3 < n) {
            String string = (String)this.append.get(n3);
            if (n3 < n2) {
                arrayList.addAll((List)this.addAll.get(string));
            } else {
                arrayList.addAll((List)this.addType.get(string));
            }
            ++n3;
        }
        String[] stringArray = new String[arrayList.size()];
        int n4 = 0;
        while (n4 < stringArray.length) {
            stringArray[n4] = (String)arrayList.get(n4);
            ++n4;
        }
        return stringArray;
    }

    public int[] getSeparatingIndex() {
        int[] nArray = new int[this.append.size() + 1];
        nArray[0] = 0;
        int n = this.addAll.size();
        int n2 = 0;
        while (n2 < this.append.size()) {
            String string = (String)this.append.get(n2);
            nArray[n2 + 1] = n2 < n ? nArray[n2] + ((List)this.addAll.get(string)).size() : nArray[n2] + ((List)this.addType.get(string)).size();
            ++n2;
        }
        return nArray;
    }

    public String writeToString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Magic);
        arrayList.add(String.valueOf(version));
        arrayList.add(this.QOIV == null ? "0" : "1");
        arrayList.add(this.QOIV);
        arrayList.add(this.add == null ? "0" : "1");
        arrayList.add(this.add);
        arrayList.add("" + this.append.size());
        arrayList.addAll(this.append);
        int n = this.addAll.size();
        arrayList.add("" + n);
        int n2 = 0;
        while (n2 < this.append.size()) {
            String string = (String)this.append.get(n2);
            List list = n2 < n ? (List)this.addAll.get(string) : (List)this.addType.get(string);
            arrayList.add("" + list.size());
            arrayList.addAll(list);
            ++n2;
        }
        arrayList.add("" + this.booleanValue);
        arrayList.add("" + this.canRelyAxisY2);
        arrayList.add("" + this.createSecondLayer);
        String string = "";
        int n3 = 0;
        while (n3 < arrayList.size() - 1) {
            string = string + ChartDefinition.booleanValue((String)arrayList.get(n3)) + ",";
            ++n3;
        }
        string = string + ChartDefinition.booleanValue((String)arrayList.get(arrayList.size() - 1));
        return string;
    }

    public void readFromString(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            this.QOIV = ChartDefinition.canRelyAxisY2(stringTokenizer.nextToken());
            stringTokenizer.nextToken();
            this.add = ChartDefinition.canRelyAxisY2(stringTokenizer.nextToken());
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.append = new ArrayList();
            int n2 = 0;
            while (n2 < n) {
                this.append.add(ChartDefinition.canRelyAxisY2(stringTokenizer.nextToken()));
                ++n2;
            }
            this.addAll = new HashMap();
            this.addType = new HashMap();
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = 0;
            while (n4 < n) {
                String string5 = (String)this.append.get(n4);
                ArrayList<String> arrayList = new ArrayList<String>();
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                int n6 = 0;
                while (n6 < n5) {
                    arrayList.add(ChartDefinition.canRelyAxisY2(stringTokenizer.nextToken()));
                    ++n6;
                }
                if (n4 < n3) {
                    this.addAll.put(string5, arrayList);
                } else {
                    this.addType.put(string5, arrayList);
                }
                ++n4;
            }
            this.booleanValue = Integer.parseInt(stringTokenizer.nextToken());
            this.canRelyAxisY2 = Integer.parseInt(stringTokenizer.nextToken());
            this.createSecondLayer = Boolean.valueOf(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final String booleanValue(String string) {
        return string == null ? createPrimaryLayer : string.replaceAll(",", containsKey);
    }

    private static final String canRelyAxisY2(String string) {
        return string.equals(createPrimaryLayer) ? null : string.replaceAll(containsKey, ",");
    }

    public void setDetail(boolean bl) {
        this.createSecondLayer = bl;
    }

    public boolean isDetail() {
        return this.createSecondLayer;
    }

    public String[] getIndexedFieldNames() {
        return this.getIndexedValueNames();
    }

    public ChartDefinition getCopyInstance() {
        ChartDefinition chartDefinition = new ChartDefinition();
        String string = this.writeToString();
        chartDefinition.readFromString(string);
        return chartDefinition;
    }

    public Map getY1Datasets() {
        return this.addAll;
    }

    public Map getY2Datasets() {
        return this.addType;
    }

    public void clearDataSets() {
        this.addAll = new HashMap();
        this.addType = new HashMap();
        this.append = new ArrayList();
    }

    public String getCategory() {
        return this.QOIV;
    }

    public void setCategory(String string) {
        this.QOIV = string;
    }

    public void setCategory(String string, boolean bl) {
        if (bl) {
            this.setCategory(string);
        } else if (string == null) {
            this.QOIV = this.containsKey();
        }
    }

    private String containsKey() {
        int n = this.append.size();
        int n2 = this.addAll.size();
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            List list;
            String string = (String)this.append.get(n3);
            if (n3 < n2) {
                list = (List)this.addAll.get(string);
                n5 = 0;
                n4 = list.size();
                if (n5 < n4) {
                    String string2 = (String)list.get(n5);
                    return string2;
                }
            } else {
                list = (List)this.addType.get(string);
                n5 = 0;
                n4 = list.size();
                if (n5 < n4) {
                    String string3 = (String)list.get(n5);
                    return string3;
                }
            }
            ++n3;
        }
        return null;
    }

    public String getSeries() {
        return this.add;
    }

    public void setSeries(String string) {
        this.add = string;
    }

    public boolean isBVData() {
        return this.equals;
    }

    public void setBVData(boolean bl) {
        this.equals = bl;
    }

    public void processReplaceChartDefinition(String string, String string2) {
        int n = this.append.size();
        int n2 = this.addAll.size();
        int n3 = 0;
        while (n3 < n) {
            String string3;
            int n4;
            int n5;
            List list;
            String string4 = (String)this.append.get(n3);
            if (n3 < n2) {
                list = (List)this.addAll.get(string4);
                n5 = 0;
                n4 = list.size();
                while (n5 < n4) {
                    string3 = (String)list.get(n5);
                    if (string3 != null && string3.equalsIgnoreCase(string)) {
                        list.set(n5, string2);
                    }
                    ++n5;
                }
            } else {
                list = (List)this.addType.get(string4);
                n5 = 0;
                n4 = list.size();
                while (n5 < n4) {
                    string3 = (String)list.get(n5);
                    if (string3 != null && string3.equalsIgnoreCase(string)) {
                        list.set(n5, string2);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        if (this.QOIV != null && this.QOIV.equalsIgnoreCase(string)) {
            this.QOIV = string2;
        }
        if (this.add != null && this.add.equalsIgnoreCase(string)) {
            this.add = string2;
        }
    }
}

